<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "amc".
 *
 * @property int $id
 * @property int $user_id
 * @property string $expiry
 * @property int $created_by
 * @property int $status
 */
class Amc extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'amc';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['user_id', 'expiry', 'created_by', 'status'], 'required'],
            [['user_id', 'created_by', 'status'], 'integer'],
            [['expiry'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'Customer',
            'expiry' => 'Expiry',
            'created_by' => 'Created By',
            'status' => 'Status',
        ];
    }

    public function getCustomer() { 
        return $this->hasOne(Customers::className(), ['id' => 'user_id']); 
    }

    

}
