<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace common\components;

use Yii;
use yii\helpers\ArrayHelper;
use common\models\SmsLog;
use common\models\Districts;
use common\models\Customers;
use common\models\User;
use common\models\ProductCategory;
use common\models\Services;
use common\models\Sales;
use common\models\Products;
use common\models\ProductUnits;
/**
 * Description of Helper
 *
 * @author HEAVENS
 */
class Helper {

    public static function RandomString($length = 10) {
        $characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }


    public static function getDays($range) {
        $date = date('Y-m-d'); //today date
        $weekOfdays = array();
        for ($i = 1; $i <= $range; $i++) {
            $date = date('Y-m-d', strtotime('+1 day', strtotime($date)));
            $weekOfdays[] = date('Y-m-d', strtotime($date));
        }
        return $weekOfdays;
    }
    public static function getDaysDiffrence($firstdate, $seconddate) {
        
        $seconddate = strtotime($seconddate);
        // $your_date = date('Y-d-m', $seconddate);;
        $datediff = $seconddate - $firstdate;
        // stop($datediff);
        return round($datediff / (60 * 60 * 24));
    }

    public static function getCustomerID() {
        $customerId = '';
        $result = Customers::find()->orderBy(['id' => SORT_DESC])->where(['role'=> User::ROLE_USER])->one();
        if ($result) {
            $id = $result->customer_id;
            if (isset($id) && $id != '') {
                $customerId = $id + 1;
                $customerId = sprintf("%06d", $customerId);
            } else {
                $customerId = '000001';
            }
        }
        else {
                $customerId = '000001';
            }
        return $customerId;
    }
    
    public static function getLastServiceID() {
        $serviceId = '';
        $result = Services::find()->orderBy(['id' => SORT_DESC])->one();
        if ($result) {
            $id = explode(Yii::$app->params['service_alias'], $result->service_number);
            if (isset($id[1]) && $id[1] != '') {
                $serviceId = $id[1] + 1;
                $serviceId = sprintf("%04d", $serviceId);
            }
        }
        return $serviceId;
    }
    
    public static function getInvoiceID() {
        $invoiceId = '';
        $result = Sales::find()->orderBy(['id' => SORT_DESC])->one();
        $financial_month = "03";
        $current_month = date('m');
        $year = date('y');
        if ($current_month < $financial_month) {
            $year = $year - 1;
        }
        $shortyear = $year . "-" . ($year + 1);
        if ($result) {
            $id = explode(Yii::$app->params['invoice_alias'], $result->invoice_number);
            $financialyear = substr($result->invoice_number, strlen(Yii::$app->params['invoice_alias'])+1, 5);
//            stop($financialyear);
            if ($financialyear == $shortyear) {
                $number = substr($result->invoice_number, 13, 13);
                $number = $number + 1;
                $invoice_number = Yii::$app->params['invoice_alias'] . "/" . $shortyear . "/" . sprintf('%03d', $number);
            } else {
                $invoice_number = Yii::$app->params['invoice_alias'] . "/" . $shortyear . "/" . "0001";
            }
        } else {
            $invoice_number = Yii::$app->params['invoice_alias'] . "/" . $shortyear . "/" . "0001";
        }
//        stop($invoice_number);
        return $invoice_number;
    }
    
    public static function getNameFromID($id) {
        $customerName = '';
        $result = User::find()->where(['id'=> $id])->one();
        if ($result) {
            $customerName = $result->name;
        }
        else {
                $customerName = '';
            }
        return $customerName;
    }
    
    public static function sendMessage($message, $mobile = null, $log = true) {
//        $office_id = Yii::$app->user->identity->office_id;
        $username = "heavens";
        $api_password = "08ca7hotufoukm21a";
        $domain = "sms.heavens.co.in";
        $priority = "11"; // 11-Enterprise, 12- Scrub
        $method = "POST";
        $sender = 'DiHugs';

//        if (COUNT($params)) {
//            foreach ($params as $key => $value) {
//                $message = str_replace('{' . $key . '}', $value, $message);
//            }
//        }

        $smsCount = ceil(strlen($message) / 160);
        $username = urlencode($username);
        $password = urlencode($api_password);
        $sender = urlencode($sender);
        $mobilemessage = urlencode($message);
        $parameters = "username=$username&api_password=$password&sender=$sender&to=$mobile&message=$mobilemessage&priority=$priority";
        $url = "http://$domain/pushsms.php";

        if ($log == true) {
            
                $ch = curl_init($url);
                if ($method == "POST") {
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $parameters);
                } else {
                    $get_url = $url . "?" . $parameters;

                    curl_setopt($ch, CURLOPT_POST, 0);
                    curl_setopt($ch, CURLOPT_URL, $get_url);
                }

                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
                curl_setopt($ch, CURLOPT_HEADER, 0);  // DO NOT RETURN HTTP HEADERS 
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);  // RETURN THE CONTENTS OF THE CALL
                $return_val = curl_exec($ch);

                $smsLog = new SmsLog();
                if ($return_val == "") {
                    return false;
                } else {
                    

                    $needle = "alert_";
                    $sentence = $return_val;
                    if (preg_match('/\b(' . preg_quote($needle, '/') . '\w+)/', $sentence, $match)) {
                        $alert_key = $match[1];
                    }
                    $arr = explode('alert_', $alert_key);
                    $return_alert_id = $arr[1];
                    $smsLog->message = $message;
                    $smsLog->count = $smsCount;
                    $smsLog->phone = $mobile;
                    $smsLog->sent_on = date('Y-m-d H:i:s');
                    $smsLog->return_val = $return_val;
                    $smsLog->return_alert_id = $return_alert_id;
                    $smsLog->status = 'Sent';
                    $smsLog->save();
                    if (!$smsLog->save()) {
                        stop($smsLog->getErrors());
                    }
                    return true;
                }
            
        } else {

            $ch = curl_init($url);
            if ($method == "POST") {
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $parameters);
            } else {
                $get_url = $url . "?" . $parameters;

                curl_setopt($ch, CURLOPT_POST, 0);
                curl_setopt($ch, CURLOPT_URL, $get_url);
            }

            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($ch, CURLOPT_HEADER, 0);  // DO NOT RETURN HTTP HEADERS 
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);  // RETURN THE CONTENTS OF THE CALL
            $return_val = curl_exec($ch);

            $smsLog = new SmsLog();
            if ($return_val == "") {
                return false;
            } else {

                $needle = "alert_";
                $sentence = $return_val;
                if (preg_match('/\b(' . preg_quote($needle, '/') . '\w+)/', $sentence, $match)) {
                    $alert_key = $match[1];
                }
                $arr = explode('alert_', $alert_key);
                $return_alert_id = $arr[1];
                $smsLog->message = $message;
                $smsLog->count = $smsCount;
                $smsLog->phone = $mobile;
                $smsLog->sent_on = date('Y-m-d H:i:s');
                $smsLog->return_val = $return_val;
                $smsLog->return_alert_id = $return_alert_id;
                $smsLog->status = 'Sent';
                $smsLog->save();
                if (!$smsLog->save()) {
                    stop($smsLog->getErrors());
                }
                return true;
            }
        }
    }

    public static function sendMail($to, $subject, $template, $attachment = false, $type = 'Sales') {
        $mail_header = "";
        $mail_footer = "";
//        $mailDetails = Configuration::find()->where(['Setting' => 'CompanyName'])->orWhere(['Setting' => 'EmailGlobalHeader'])->orWhere(['Setting' => 'EmailGlobalFooter'])->all();
//        foreach ($mailDetails as $key => $value) {
//            if ($value->setting == 'CompanyName') {
//                $company_name = $value->value;
//            }
//            if ($value->setting == 'EmailGlobalFooter') {
//                $mail_footer = $value->value;
//            }
//            if ($value->setting == 'EmailGlobalHeader') {
//                $mail_header = $value->value;
//            }
//        }

        $config = [
            'class' => 'yii\swiftmailer\Mailer',
            // 'viewPath' => '@common/mail',
            'useFileTransport' => false,
            'transport' => [
                'class' => 'Swift_SmtpTransport',
                'host' => 'mail.digitalhugs.in',
                'username' => 'no-reply@digitalhugs.in',
                'password' => '0WXPiZJ},y.+',
                'port' => '465',
                'encryption' => 'ssl',
            ],
        ];

        $fullcontent = $mail_header . $template . $mail_footer;

        $user = User::find()->where(['email' => $to])->one();
        if ($user) {
            $emails = new EmailsSent();
            $emails->user_id = $user->id;
            $emails->sent_on = date('Y-m-d H:i:s');
            $emails->email = $to;
            $emails->subjet = $subject;
            $emails->message = $fullcontent;
            $emails->save();
        }
        $sendObj = Yii::createObject($config);
        $from = array("no-reply@digitalhugs.in" => 'Digital Hugs ' . $type . ' Team');
        $admin = "heavenswebsolutions@gmail.com";
        $message = $sendObj->compose()
                ->setFrom($from)
                ->setTo($to)
                ->setBcc($admin)
                ->setSubject($subject)
                ->setTextBody('Digital Hugs')
                ->setHtmlBody($fullcontent);
        if ($attachment)
            $message->attach($attachment);
        $message->send();
//            return $message;
    }

    public static function getMailBody($templateData, $replaceParams) {
        foreach ($replaceParams as $key => $value) {
            $templateData = str_replace('{$' . $key . '}', $value, $templateData);
        }
        return $templateData;
    }

    public static function UniqueRandomNumbersWithinRange($min, $max, $quantity) {
        $numbers = range($min, $max);
        shuffle($numbers);
        return array_slice($numbers, 0, $quantity);
    }
    
    public static function UniqueRandomNumber() {
        return mt_rand(100000, 999999);
    }
    
    public static function logVisiters($uniqId) {
        $session = Yii::$app->session;
        if (!isset($session['logged']) || !$session['logged']) {
            $ip = $_SERVER['REMOTE_ADDR'];
            if ($ip != "") {
                $ifExist = visitersLog::find()->Where(['ip' => $ip])->one();
                if (!$ifExist) {
                    $visitersLog = new visitersLog();
                    $visitersLog->ip = $ip;
                    $visitersLog->unique_id = $uniqId;
                    $visitersLog->visited_on = Date('Y-m-d');
                    $visitersLog->save();
                    $session->set('logged', TRUE);
                }
            }
        }
    }

    public static function getAllDistricts() {
        $districts = Districts::find()->all();
        $districts = ArrayHelper::map($districts, 'id', 'name');
        return $districts;
    }
    
    public static function getDistrict($id) {
        $district = Districts::findOne($id);
        return $district->name;
    }
    
    public static function getProductDetails($id) {
        $Product = Products::findOne($id);
        return $Product;
    }
    
    public static function getProductCatagoryDetails($id) {
        $Catagory = ProductCategory::findOne($id);
        return $Catagory;
    }
    
    public static function getAllProductCatagory() {
        $ProductCategory = ProductCategory::find()->all();
        $ProductCategory = ArrayHelper::map($ProductCategory, 'id', 'cat_name');
        return $ProductCategory;
    }
    public static function getMainProductCatagory() {
        $ProductCategory = ProductCategory::find()->where("parrent_id=0")->all();
        $ProductCategory = ArrayHelper::map($ProductCategory, 'id', 'cat_name');
        return $ProductCategory;
    }
    public static function getProductUnit($id) {
        $unit = ProductUnits::findOne($id);
        return $unit;
    }
}
