<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;

/* @var $this yii\web\View */
/* @var $searchModel common\models\StaffsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Staffs';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="staffs-index">

    <p>
        <?= Html::a('Create Staffs', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
 <div class="box clearfix">
        <div class="box-body table-responsive">
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        // 'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'username',
            'name',
            'email',
            'mobile',
            [
                        'attribute' => 'status',
                        'format' => 'raw',
                        'value' => function($data) {
                            return $data->status == 0 ? Html::a('Inactive', 'Javascript:void(0)', ['class' => 'btn btn-xs btn-warning']) : Html::a('Active', 'Javascript:void(0)', ['class' => 'btn btn-xs btn-success']);
                        },
                        'filter' => Html::activeDropDownList($searchModel, 'status', ["1" => "Active", "0" => "Inactive"], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
            ['class' => 'yii\grid\ActionColumn',
                        'headerOptions' => ['class' => 'action-column'],
                        'contentOptions' => ['style' => 'width:50px;'],
                        'header' => 'Actions',
                        'visible' => (Yii::$app->user->identity->role == (User::ROLE_SUPER_ADMIN || User::ROLE_ADMIN)),
                        'template' => '{view}{update}{delete}',
                        'visibleButtons' => [
                            'view' => false,
                            'update' => true,
                            'delete' => false,
                        ],
                        'buttons' => [
                            'view' => function ($url, $model) {
                                return Html::a('<div class="btn btn-success btn-flat btn-xs"><span class="glyphicon glyphicon-eye-open"></span></div>', $url, [
                                            'title' => Yii::t('app', 'customer-view'),
                                ]);
                            },
                                    'update' => function ($url, $model) {
                                return Html::a('<div class="btn btn-info btn-flat btn-xs"><span class="glyphicon glyphicon-pencil"></span> Edit</div>', $url, [
                                            'title' => Yii::t('app', 'customer-update'),
                                ]);
                            },
                                    'delete' => function ($url, $model) {
                                return Html::a('<div class="btn btn-danger btn-flat btn-xs"><span class="glyphicon glyphicon-trash"></span></div>', $url, [
                                            'title' => Yii::t('app', 'customer-delete'),
                                ]);
                            }
                                ],
                            ],
        ],
    ]); ?>
        </div>
 </div>

</div>
