<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model common\models\Staffs */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="staffs-form">
    <div class="box clearfix ">
        <div class="box-body table-responsive">
            <div class="col-md-12">
                <?php $form = ActiveForm::begin(); ?>
                <div class="row">
                    <div class="col-md-6">
                        <?= $form->field($model, 'username')->textInput(['maxlength' => true])->label('Login Id / username') ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?= $form->field($model, 'mobile')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?= $form->field($model, 'address')->textarea(['rows' => 6]) ?>
                    </div>
                </div>
                <div class="row">    
                    <div class="col-md-6">
                        <?= $form->field($model, 'status')->dropDownList(['1' => 'Active', '0' => 'Inactive'], ['prompt' => 'Select Status']) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-md-12">
                        <?= Html::submitButton($model->isNewRecord ? 'Create Customer' : 'Update Customer', ['class' => $model->isNewRecord ? 'btn btn-success create-btn' : 'btn btn-primary create-btn']) ?>
                    </div>
                </div>
                <?php ActiveForm::end(); ?>
            </div>
        </div>
    </div>
</div>
