<?php

use yii\widgets\DetailView;
use common\components\Helper;
/* @var $this yii\web\View */
/* @var $model common\models\Services */

$this->title = $model->service_number;
$this->params['breadcrumbs'][] = ['label' => 'Services', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="services-view col-md-5">
<div class="box clearfix ">
        <div class="box-body table-responsive">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label">Customer</label>
                            <div class="form-control">
                                <?= Helper::getNameFromID($model->user_id); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label">Service Note</label>
                            <div class="form-control h-auto">
                                <?= $model->service_note; ?>
                            </div>
                        </div>  
                    </div>    
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Call type</label>
                            <div class="form-control">
                                <?= $model->call_type; ?>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Service type</label>
                            <div class="form-control">
                            <?= $model->service_type; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Completion Date</label>
                            <div class="form-control">
                                <?= $model->completion_date; ?>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Service Mode</label>
                            <div class="form-control">
                            <?= $model->service_mode." "."Service"; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label"> Total Amount</label>
                            <div class="form-control">
                                <?= $model->total_amount; ?>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Status</label>
                            <div class="form-control">
                            <?= $model->status; ?>
                            </div>
                        </div>
                    </div>
                </div>


    

</div>
