<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use kartik\select2\Select2;
use yii\web\JsExpression;
use common\models\Customers;
use common\models\Staffs;
/* @var $this yii\web\View */
/* @var $model common\models\Services */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="payment-form">

    <?php $form = ActiveForm::begin(); ?>
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Service Number</label>
                            <div class="form-control">
                                <?= $model->service_number; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Pending Amount</label>
                            <div class="form-control">
                                <?= $pending_amount; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label">Service Note</label>
                            <div class="form-control h-auto">
                                <?= $model->service_note; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                    <?= $form->field($payments, 'note')->textarea(['rows' => 6])->label('Payment Note'); ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                            <?= $form->field($payments, 'amount')->textInput() ?>
                        </div>
                        <div class="col-md-6">
                        <?= $form->field($payments, 'transaction_date')->widget(DatePicker::classname(), [
                                'options' => ['placeholder' => ''],
                                'pluginOptions' => [
                                    'format' => 'yyyy-mm-dd',
                                    'autoclose' => true,
                                    'todayHighlight' => true
                                ]
                            ]);
                        ?>
                    </div>
                </div>
                            
                <div class="form-group">
                    <?= Html::submitButton('Add Payment', ['class' => 'btn btn-success']) ?>
                </div>
            </div>
    <?php ActiveForm::end(); ?>

</div>
<?php
$this->registerJs(
        " $(document).ready(function () {
        $('#orders-form').on('beforeSubmit', function (e) {
            $('.btn').addClass('disabled');
        });
    });"
);
?>