<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use yii\helpers\Url;
use common\components\Helper;

/* @var $this yii\web\View */
/* @var $invoice common\models\Sales */

$this->title = $invoice->id;
$this->params['breadcrumbs'][] = ['label' => 'Sales', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
//stop($customer);
?>
<div class="sales-view">

    <div class="ol-md-6">
        <style>
            .view-invoice {
                border: 1px solid #ccc;
                padding: 70px;
                background: #fff;
            }

            .view-invoice h1 {
                font-size: 25px;
                margin-bottom: 100px;
                text-align: center;
                text-transform: uppercase;
            }

            .view-invoice p {
                margin: 0
            }

            .mrg-b-20 {
                margin-bottom: 10px;
            }

            .client-address {
                max-width: 300px;
            }
        </style>
        <div class="dashboard">
            <div class="container">
                <div class="view-invoice">
                    <h1>Invoice</h1>
                    <table class="invoice-main">
                        <tr>
                            <td class="th2 brd-r"><h2><?= $company['company_name'] ?></h2></td>
                            <td style="position: relative;">
                                <p><?= $company['company_name'] ?>,</p>
                                <p><?= nl2br($company->address); ?>,</p>
                                <p><?= $company['stateName']['name'] ?> - <?= $company->pin ?></p>
                                <p><?= $company['countryName']['name'] ?></p>
                                <p style="position: absolute; bottom: 0; right: 0px; padding: 10px; background: #ccc; font-weight: 500;">State Code :<?= $company['stateName']['gst_code'] ?></p>
                                <p>GSTIN :<?= $company->gstin ?></p>
                            </td>
                        </tr>
                        <tr>
                            <td class="th2 brd-r" style="position: relative;">
                                <p><b>Billed /Invoiced To </b></p>
                                <p><?php
//                                    if ($customer->company_name != '') {
//                                        $customer_name = $customer->first_name . ' ' . $customer->last_name . " (" . $customer->company_name . ")";
//                                    } else {
//                                        $customer_name = $customer->first_name . ' ' . $customer->last_name;
//                                    }
                                    $customer_name = $customer->name;
                                    echo $customer_name;
                                    ?>,</p>
                                <p><?= nl2br($customer->address); ?>,</p>
                                <p><?= $customer['stateName']['name'] ?> - <?= $company->pin ?></p>
                                <p><?= $customer['countryName']['name'] ?></p>
                                <p style="position: absolute; bottom: 0; right: 0px; padding: 10px; background: #ccc; font-weight: 500;">State Code :<?= $customer['stateName']['gst_code'] ?></p>
                            </td>
                            <td>
                                    <p style='padding:0px; margin:0px;'>Invoice #
                                        <?= $invoice->invoice_number; ?>
                                    </p>
                                    <p style='padding:0px; margin:0px;'>Invoice date :
                                        <?= $invoice->invoice_date ?>
                                    </p>
                                    <p style='padding:0px; margin:0px;'>Due date :
                                        <?= $invoice->due_date ?>
                                    </p>
                            </td>
                        </tr>
                    </table>
                    <table class="order-details">
                        <thead>
                            <tr>
                                <th class="brd-r" rowspan="2" style="white-space: nowrap;">Item No</th>
                                <th class="th1" rowspan="2">Description of Goods</th>
                                <th class="brd-r" rowspan="2">HSN / ACS</th>
                                <th class="brd-r" rowspan="2">Qty</th>
                                <th class="brd-r" rowspan="2">Rate</th>
                                <th class="brd-r" rowspan="2">AMT</th>
                                <th class="brd-r" colspan="2">CGST</th>
                                <th class="brd-r" colspan="2">SGST</th>
                                <th class="brd-r" rowspan="2">TOTAL</th>
                            </tr>
                            <tr>
                                <th class="brd-r" style="white-space: nowrap;">Rate %</th>
                                <th class="brd-r">Amt</th>
                                <th class="brd-r" style="white-space: nowrap;">Rate %</th>
                                <th class="brd-r">Amt</th>
                            </tr>
                        </thead>
                        <?php
                        foreach ($itemmodel as $key => $value) {
                            ?>
                            <tr class="details">
                                <td class="brd-r">
                                    <p>
                                        <?= $key + 1 ?>
                                    </p>
                                </td>
                                <td class="brd-r">
                                    <p>
                                        <?= $value['cat_name'] . " " . $value['product_name'] ?>
                                    </p>
                                </td>
                                <td class="brd-r">
                                    <p>
                                        <?= $value['hsn_code'] ?>
                                    </p>
                                </td>
                                <td class="brd-r">
                                    <p style="white-space: nowrap;">
                                        <?= $value['qty'] . " " . $value['unit'] ?>
                                    </p>
                                </td>
                                <td class="brd-r">
                                    <p>
                                        <?= $value['price'] ?>
                                    </p>
                                </td>
                                <td class="brd-r">
                                    <p>
                                        <?= $value['qty'] * $value['price'] ?>
                                    </p>
                                </td>

                                <td class="brd-r">
                                    <p>
                                        <?= $value['gst_percent'] / 2 . " %" ?>
                                    </p>
                                </td>

                                <td class="brd-r">
                                    <p>
                                        <?= $value['cgst'] ?>
                                    </p>
                                </td>
                                <td class="brd-r">
                                    <p>
                                        <?= $value['gst_percent'] / 2 . " %" ?>
                                    </p>
                                </td>
                                <td class="brd-r">
                                    <p>
                                        <?= $value['sgst'] ?>
                                    </p>
                                </td>



                                <td>
                                    <p>
                                        <?= $value['total_amout'] ?>
                                    </p>
                                </td>
                            </tr>
                        <?php } ?>
                        <tr class="details">
                            <td class="brd-r" ></td>
                            <td class="brd-r" ></td>
                            <td class="brd-r" ></td>
                            <td class="brd-r" ></td>
                            <td class="brd-r"></td>
                            <td class="brd-r"></td>
                            <td class="brd-r"></td>
                            <td class="brd-r"></td>
                            <td class="brd-r"></td>
                            <td class="brd-r"></td>
                            <td class="brd-r"></td>
                        </tr>    
                        <tr>
                            <td class="th1" colspan="5"><b>Total</b></td>
                            <td class="brd-r"><?= $invoice['sub_total'] ?></td>
                            <td class="brd-r"></td>
                            <td class="brd-r"><?= $invoice['sgst'] ?></td>
                            <td class="brd-r"></td>
                            <td class="brd-r"><?= $invoice['cgst'] ?></td>
                            <td class="brd-r"><?= $invoice['invoice_amount'] ?></td>
                        </tr>
                        <tr>

                            <td class="brd-r" rowspan="6" colspan="5" style="vertical-align: top; position: relative;">
                                <p><b>Total invoice amount in words</b> <br>
                                    <?= ucwords(strtolower(Helper::getIndianCurrency($invoice['invoice_amount']))); ?>
                                </p>
                                <div style="position: absolute; bottom: 5px; right: 5px; padding: 10px; background: #ccc; font-weight: 500;">
                                    <b>Bank Account details</b>
                                    <p>Acount Name : <?= $company['bank_name'] ?></p>
                                    <p>Account Number : <?= $company['acc_number'] ?></p>
                                    <p>IFSC : <?= $company['ifsc'] ?></p>
                                    <p>Branch : <?= $company['branch'] ?></p>
                                </div>
                            </td>
                        </tr>    
                        <tr class="details-discount">
                            <td colspan="5" class="text-right brd-r" style='font-weight:bold;'>
                                <p>Amount Before Tax :</p>
                            </td>
                            <td style='font-weight:bold;'>
                                <p>
                                    <?= $invoice->sub_total ?>
                                </p>
                            </td>
                        </tr>

                        <tr class="details-tax" >
                            <td colspan="5" class="text-right brd-r" style='font-weight:bold;'>
                                <p>SGST :</p>
                            </td>
                            <td style='font-weight:bold;'>
                                <p><?= $invoice['sgst'] ?></p>
                            </td>
                        </tr>
                        <tr class="details-tax">
                            <td colspan="5" class="text-right brd-r" style='font-weight:bold;'>
                                <p>CGST :</p>
                            </td>
                            <td style='font-weight:bold;'>
                                <p><?= $invoice['cgst'] ?></p>
                            </td>
                        </tr>
                        <tr class="details-discount">
                            <td colspan="5" class="text-right brd-r" style='font-weight:bold;'>
                                <p>Discount :</p>
                            </td>
                            <td style='font-weight:bold;'>
                                <p>
                                    <?= $invoice->discount_amount ?>
                                </p>
                            </td>
                        </tr>
                        <tr class="details-total">
                            <td colspan="5" class="text-right brd-r" style='font-weight:bold;'>
                                <p>Total Amount After Tax:</p>
                            </td>
                            <td style='font-weight:bold;'>
                                <p>
                                    <?= $invoice['invoice_amount'] ?>
                                </p>
                            </td>
                        </tr>
                    </table>
                    <!--<div class="panel panel-success">
                        <div class="panel-heading">
                            <h3 class="panel-title"><strong>Apply Credit</strong></h3> </div>
                        <div class="panel-body">
                            <form method="post" action="/clients/viewinvoice.php?id=29545">
                                <input type="hidden" name="applycredit" value="true"> Your credit balance is <strong>Rs. 30 INR<input type="hidden" name="token" value="e21a130397762d4ef00742b1724986886d10049a"></strong>. This can be applied to the invoice using the form below.. Enter the amount to apply:
                                <div class="row">
                                    <div class="col-xs-8 col-xs-offset-2 col-sm-4 col-sm-offset-4">
                                        <div class="input-group">
                                            <input type="text" name="creditamount" value="30" class="form-control"> <span class="input-group-btn">
                                        <input type="submit" value="Apply Credit" class="btn btn-success">
                                    </span> </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>-->
                    <?php
//                    if ($invoice->status == 'Unpaid') {
                    ?>

                    <div class="panel panel-info">
                        <div class="panel-heading">
                            <h3 class="panel-title"><strong>Make Payment</strong></h3> </div>
                        <div class="panel-body">
                            <form method="post" action="<?php echo Url::to(['payment/make-payment']); ?>" class="gateway">

                                <select name="gateway" >
                                    <option value="Instamojo">Instamojo(India Only)</option>
                                </select>
                                <input type="hidden" name="invoiceId" value="<?php //echo $invoice->id;     ?>">
                                <input type="submit" value="Make Payment" class="btn btn-success"> </form>
                        </div>
                    </div>
                    <?php
//                    }
                    ?>
                    <h3 class="text-center">Transactions</h3>
                    <table class="transaction-details">
                        <thead>
                            <tr>
                                <th class="th0">
                                    <p>Transaction Date</p>
                                </th>
                                <th class="th1">
                                    <p>Gateway</p>
                                </th>
                                <th class="th2 brd-r">
                                    <p>Transaction ID</p>
                                </th>
                                <th>
                                    <p>Amount</p>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="details">
                                <td class="brd-r">
                                    <p>Date</p>
                                </td>
                                <td class="brd-r">
                                    <p>Description</p>
                                </td>
                                <td class="brd-r">
                                    <p>Description</p>
                                </td>
                                <td>
                                    <p>Total</p>
                                </td>
                            </tr>
                            <tr class="details">
                                <td colspan="4" class="text-center">
                                    <p>No Related Transactions Found</p>
                                </td>
                            </tr>
                            <tr class="details-discount">
                                <td colspan="3" class="text-right brd-r" style='font-weight:bold;'>
                                    <p>Balance Due :</p>
                                </td>
                                <td>
                                    <p style='font-weight:bold;'>
                                        Balance Due
                                    </p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <div class="pull-right">
                        <?= Html::a('<i class="fa fa-download"></i> Download', ['sales/download-invoice','id'=>$invoice->id]) ?> </div>
                </div>
            </div>
        </div>
    </div>

</div>
<?php
$this->registerCssFile(Url::base() . '/css/invoice.css', [
    'depends' => [\yii\web\JqueryAsset::className()]
]);
?>