<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\Url;
use common\components\Helper;
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <title></title>
        <link rel="stylesheet" href="style.css" media="all" />
    </head>
    <body>

        <div class="view-invoice">
            <h1>Invoice</h1>
            <header class="clearfix">

                <div style='width: 100%; margin-bottom:25px;'>
                    <div style='float: left; width: 70%'>
                        <div class="companydetails">
                            <?php if($company['logo']!==''){?>
                            <div id="logo" style='margin-bottom:15px;'>
                                <img src="<?php echo Yii::getAlias('@web') ?>/images/logo.png">
                            </div>
                            <?php }?>
                            <?= $company['company_name'] ?>,<br>
                            <p><?= $company->address; ?>,</p>
                            <p><?= $company['stateName']['name'] ?> - <?= $company->pin ?>, State Code :<?= $company['stateName']['gst_code'] ?>, <?= $company['countryName']['name'] ?></p>
                            <p>GSTIN :<?= $company->gstin ?></p>
                            </div>
                    </div>
                    <div style='float: left; width: 30%'>
                        <div class="<?php echo ($invoice->status == 'Paid') ? 'invoice-status-paid' : 'invoice-status-unpaid' ?>">Invoice <br> <span><?= $invoice->status ?></span></div>
                    </div>
                </div>
                <div style='width: 100%; margin-bottom:25px;'>
                    <div style='float: left; width: 70%'>
                        <div class="client-details">
                            <h3>Invoiced to</h3>
                            <div class="client-address">
                                <p><?php
                                    $customer_name = $customer->name;
                                    echo $customer_name;
                                    ?>,</p>
                                <p><?= nl2br($customer->address); ?>,</p>
                                <p><?= $customer['stateName']['name'] ?> - <?= $company->pin ?>, State Code :<?= $customer['stateName']['gst_code'] ?>, <?= $customer['countryName']['name'] ?></p>
                            </div>
                        </div>
                    </div>
                    <div style='float: left; width: 30%'>
                        <div class="invoice-details">
                            <p style='padding:0px; margin:0px;'>Invoice #
                                <?= $invoice->invoice_number; ?>
                            </p>
                            <p style='padding:0px; margin:0px;'>Invoice date :
                                <?= $invoice->invoice_date ?>
                            </p>
                            <p style='padding:0px; margin:0px;'>Due date :
                                <?= $invoice->due_date ?>
                            </p>
                        </div>
                    </div>
                </div>


            </header>

            <main>
                <table class="order-details">
                    <thead>
                        <tr>
                            <th class="brd-r" style="width:50px;" rowspan="2">Item No</th>
                            <th class="th40" rowspan="2">Description of Goods</th>
                            <th class="brd-r" rowspan="2" style="width:50px;">HSN / ACS</th>
                            <th class="brd-r" rowspan="2" style="width:50px;">Qty</th>
                            <th class="brd-r" rowspan="2">Rate</th>
                            <th class="brd-r" rowspan="2">AMT</th>
                            <th class="brd-r" colspan="2">CGST</th>
                            <th class="brd-r" colspan="2">SGST</th>
                            <th class="brd-r" rowspan="2">TOTAL</th>
                        </tr>
                        <tr>
                            <th class="brd-r w-5p" style="white-space: nowrap;"> %</th>
                            <th class="brd-r">Amt</th>
                            <th class="brd-r" style="white-space: nowrap;"> %</th>
                            <th class="brd-r">Amt</th>
                        </tr>
                    </thead>
                    <?php
                    foreach ($itemmodel as $key => $value) {
                        ?>
                        <tr class="details">
                            <td class="brd-r">
                                <p>
                                    <?= $key + 1 ?>
                                </p>
                            </td>
                            <td class="brd-r">
                                <p>
                                    <?= $value['cat_name'] . " " . $value['product_name'] ?>
                                </p>
                            </td>
                            <td class="brd-r">
                                <p>
                                    <?= $value['hsn_code'] ?>
                                </p>
                            </td>
                            <td class="brd-r">
                                <p>
                                    <?= $value['qty'] . " " . $value['unit'] ?>
                                </p>
                            </td>
                            <td class="brd-r">
                                <p>
                                    <?= $value['price'] ?>
                                </p>
                            </td>
                            <td class="brd-r" style="white-space: nowrap;">
                                <p style="white-space: nowrap;">
                                    <?= $value['qty'] * $value['price'] ?>
                                </p>
                            </td>

                            <td class="brd-r" style="white-space: nowrap;">
                                <p style="white-space: nowrap;">
                                    <?= $value['gst_percent'] / 2 . " %" ?>
                                </p>
                            </td>

                            <td class="brd-r">
                                <p>
                                    <?= $value['cgst'] ?>
                                </p>
                            </td>
                            <td class="brd-r" style="white-space: nowrap;">
                                <p style="white-space: nowrap;">
                                    <?= $value['gst_percent'] / 2 . " %" ?>
                                </p>
                            </td>
                            <td class="brd-r">
                                <p>
                                    <?= $value['sgst'] ?>
                                </p>
                            </td>



                            <td>
                                <p>
                                    <?= $value['total_amout'] ?>
                                </p>
                            </td>
                        </tr>
                    <?php } ?>
                    <tr class="">
                        <td class="brd-r" ></td>
                        <td class="brd-r" ></td>
                        <td class="brd-r" ></td>
                        <td class="brd-r" ></td>
                        <td class="brd-r"></td>
                        <td class="brd-r"></td>
                        <td class="brd-r"></td>
                        <td class="brd-r"></td>
                        <td class="brd-r"></td>
                        <td class="brd-r"></td>
                        <td class="brd-r"></td>
                    </tr>    
                    <tr>
                        <td class="" colspan="5"><b>Total</b></td>
                        <td class="brd-r"><?= $invoice['sub_total'] ?></td>
                        <td class="brd-r"></td>
                        <td class="brd-r"><?= $invoice['sgst'] ?></td>
                        <td class="brd-r"></td>
                        <td class="brd-r"><?= $invoice['cgst'] ?></td>
                        <td class="brd-r"><?= $invoice['invoice_amount'] ?></td>
                    </tr>
                    <tr>

                        <td class="brd-r aditonal-details" rowspan="6" colspan="5">
                            <p><b>Total invoice amount in words</b> <br>
                                <?= ucwords(strtolower(Helper::getIndianCurrency($invoice['invoice_amount']))); ?>
                                <br><br>
                            </p>

                            <div class="bank-details">
                                <b>Bank Account details</b>
                                <p>Acount Name : <?= $company['bank_name'] ?></p>
                                <p>Account Number : <?= $company['acc_number'] ?></p>
                                <p>IFSC : <?= $company['ifsc'] ?></p>
                                <p>Branch : <?= $company['branch'] ?></p>
                            </div>
                        </td>
                    </tr>    
                    <tr class="details-discount">
                        <td colspan="5" class="text-right brd-r" style='font-weight:bold;'>
                            <p>Amount Before Tax :</p>
                        </td>
                        <td style='font-weight:bold;'>
                            <p>
                                <?= $invoice->sub_total ?>
                            </p>
                        </td>
                    </tr>

                    <tr class="details-tax" >
                        <td colspan="5" class="text-right brd-r" style='font-weight:bold;'>
                            <p>SGST :</p>
                        </td>
                        <td style='font-weight:bold;'>
                            <p><?= $invoice['sgst'] ?></p>
                        </td>
                    </tr>
                    <tr class="details-tax">
                        <td colspan="5" class="text-right brd-r" style='font-weight:bold;'>
                            <p>CGST :</p>
                        </td>
                        <td style='font-weight:bold;'>
                            <p><?= $invoice['cgst'] ?></p>
                        </td>
                    </tr>
                    <tr class="details-discount">
                        <td colspan="5" class="text-right brd-r" style='font-weight:bold;'>
                            <p>Discount :</p>
                        </td>
                        <td style='font-weight:bold;'>
                            <p>
                                <?= $invoice->discount_amount ?>
                            </p>
                        </td>
                    </tr>
                    <tr class="details-total">
                        <td colspan="5" class="text-right brd-r" style='font-weight:bold;'>
                            <p>Total Amount After Tax:</p>
                        </td>
                        <td style='font-weight:bold;'>
                            <p>
                                <?= $invoice['invoice_amount'] ?>
                            </p>
                        </td>
                    </tr>
                </table>

                <!--<h3 class="text-center">Transactions</h3>-->

<!--            <table class="transaction-details">
                <thead>
                    <tr>
                        <th class="th0">
                            <p>Transaction Date</p>
                        </th>
                        <th class="th1">
                            <p>Gateway</p>
                        </th>
                        <th class="th2 brd-r">
                            <p>Transaction ID</p>
                        </th>
                        <th>
                            <p>Amount</p>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="details">
                        <td class="brd-r">
                            <p>Date</p>
                        </td>
                        <td class="brd-r">
                            <p>Description</p>
                        </td>
                        <td class="brd-r">
                            <p>Description</p>
                        </td>
                        <td>
                            <p>Total</p>
                        </td>
                    </tr>
                    <tr class="details">
                        <td colspan="4" class="text-center">
                            <p>No Related Transactions Found</p>
                        </td>
                    </tr>
                    <tr class="details-discount" >
                        <td colspan="3" class="text-right brd-r" style='font-weight:bold;'>
                            <p>Balance Due :</p>
                        </td>
                        <td>
                            <p style='font-weight:bold;'> <?= $invoice->invoice_amount ?></p>
                        </td>
                    </tr>
                </tbody>
            </table>-->

                <div id="notices">
                    <div>NOTICE:</div>
                    <div class="notice">A finance charge of 1.5% will be made on unpaid balances after 30 days.</div>
                </div>
            </main>
        </div>
        <footer>
            Invoice was created on a computer and is valid without the signature and seal.
        </footer>
    </body>

</html>
