<?php

use yii\helpers\Url;
use yii\helpers\Html;
use yii\grid\GridView;
use common\models\Sales;
use yii\bootstrap\ButtonDropdown;

/* @var $this yii\web\View */
/* @var $searchModel common\models\SalesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Sales';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="sales-index">

    <p>
        <?= Html::a('Create Sales', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]);  ?>
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
//            'id',
                    ['attribute' => 'user_id',
                                'value' => 'customer.name',
                                'filter' => false
                            ],
//                    'invoice_number',
                    'invoice_date',
                    'due_date',
                    //'notes:ntext',
                    //'private_notes:ntext',
                    'sub_total',
//                    'discount_amount',
                    //'cgst',
                    //'sgst',
                    //'igst',
//                    'total_tax',
//                    'invoice_amount',
                    //'status',
                    //'freight',
//                    'round_off',
//                    'amount_received',
//                    'balance',
                    ['class' => 'yii\grid\ActionColumn',
                        'headerOptions' => ['class' => 'action-column'],
//                        'contentOptions' => ['style' => 'width:50px;'],
                        'header' => 'Actions',
//                        'visible' => (Yii::$app->user->identity->role == (User::ROLE_ADMIN || User::ROLE_STAFF)),
                        'template' => '{view}{update}{return}{delete}',
                        'visibleButtons' => [
                            'view' => false,
                            'update' => true,
                            'return' => false,
                            'delete' => true,
                        ],
                        'buttons' => [
                            'view' => function ($url, $model) {
                                return Html::a('<div class="btn btn-success btn-flat btn-xs"><span class="glyphicon glyphicon-eye-open"></span> View</div>', $url, [
                                            'title' => Yii::t('app', 'View Invoice'),
                                ]);
                            },
                                    'update' => function ($url, $model) {
                                return Html::a('<div class="btn btn-info btn-flat btn-xs"><span class="glyphicon glyphicon-pencil"></span> Edit</div>', $url, [
                                            'title' => Yii::t('app', 'Edit sales'),
                                ]);
                            },
                                    'return' => function ($url, $model) {
                                $url = Url::to(['sales-return/create', 'sales-id' => $model->id]);
                                    return Html::a('<div class="btn bg-purple btn-flat btn-xs"><span class="glyphicon glyphicon-repeat"></span> Return</div>', $url, [
                                                'title' => 'Sales return',
                                    ]);
                                
                            },
                                    'delete' => function ($url, $model) {
                                $url = Url::to(['sales/delete', 'id' => $model->id]);
                                $result = Sales::find()->orderBy(['id' => SORT_DESC])->one();
                                if ($result->id <= $model->id) {
                                    return Html::a('<div class="btn btn-danger btn-flat btn-xs"><span class="glyphicon glyphicon-trash"></span> Delete</div>', $url, [
                                                'title' => 'delete',
                                                'data-confirm' => Yii::t('yii', 'Are you sure you want to delete this item?'),
                                                'data-method' => 'post',
                                    ]);
                                }
                            },
                                ],
                            ],
//                    [
//                        'class' => 'yii\grid\ActionColumn',
//                        'template' => '{all}',
//                        'buttons' => [
//                            'all' => function ($url, $model, $key) {
//                                return ButtonDropdown::widget([
//                                            'encodeLabel' => false, // if you're going to use html on the button label
//                                            'label' => '<span class="glyphicon glyphicon-eye-open"></span> Actions',
//                                            'dropdown' => [
//                                                'encodeLabels' => false, // if you're going to use html on the items' labels
//                                                'items' => [
//                                                    [
//                                                        'label' => \Yii::t('yii', '<span class="glyphicon glyphicon-eye-open"></span> View'),
//                                                        'url' => ['view', 'id' => $key],
//                                                        'linkOptions' => [
//                                                        'class' => 'btn btn-success btn-flat btn-xs'
//                                                            ],
//                                                    ],
//                                                    [
//                                                        'label' => \Yii::t('yii', 'Update'),
//                                                        'url' => ['update', 'id' => $key],
//                                                        'visible' => true, // if you want to hide an item based on a condition, use this
//                                                    ],
//                                                    [
//                                                        'label' => \Yii::t('yii', 'Delete'),
//                                                        'linkOptions' => [
//                                                            'data' => [
//                                                                'method' => 'post',
//                                                                'confirm' => \Yii::t('yii', 'Are you sure you want to delete this item?'),
//                                                            ],
//                                                        ],
//                                                        'url' => ['delete', 'id' => $key],
//                                                        
//                                                        'visible' => true, // same as above
//                                                    ],
//                                                ],
//                                                'options' => [
//                                                    'class' => 'dropdown-menu-right', // right dropdown
//                                                ],
//                                            ],
//                                            'options' => [
//                                                'class' => 'btn-default', // btn-success, btn-info, et cetera
//                                            ],
//                                            'split' => false, // if you want a split button
//                                ]);
//                            },
//                                ],
//                            ],
                        ],
                    ]);
                    ?>

        </div>
    </div>
</div>
