<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use kartik\time\TimePicker;
use wbraganca\dynamicform\DynamicFormWidget;
use common\models\Products;
use kartik\select2\Select2;
use common\models\Customers;
/* @var $this yii\web\View */
/* @var $model common\models\Sales */
/* @var $form yii\widgets\ActiveForm */
$js = '

';

$this->registerJs($js, $this::POS_HEAD);

$script = '

$(document).on("change", ".change", function() {
    var id = this.id;
    var idx =  id.replace(/[^0-9]/g,"");

    var tax = $("#salesitems-" + idx +"-gst_percent").val(); ; 
    var subtotal = 0;
    var cgst = 0;
    var sgst = 0;
    var igst  = 0;
    var totaltax  = 0;
    var invoicetotal = 0;
    
    if(this.checked) {
        var includedtaxprice = $("#salesitems-" + idx +"-mrp").val() / ((tax/100)+1);
        $("#salesitems-" + idx +"-price").val(includedtaxprice);
        var itemsubtotal=  Math.round($("#salesitems-" + idx + "-qty").val() * includedtaxprice);
        var itemtax = Math.round(itemsubtotal * tax/100);
    }
    else
    {
        $("#salesitems-" + idx +"-price").val($("#salesitems-" + idx +"-mrp").val());
        var itemsubtotal=  $("#salesitems-" + idx + "-qty").val() * $("#salesitems-" + idx +"-mrp").val();
        var itemtax = itemsubtotal*tax/100;
    }
    
    var itemtotal = parseInt(itemsubtotal) + parseInt(itemtax);

    $("#salesitems-" + idx + "-sgst").val(itemtax/2);
    $("#salesitems-" + idx + "-cgst").val(itemtax/2);
    $("#salesitems-" + idx +"-total_tax").val(itemtax);
    $("#salesitems-" + idx +"-sub_total").val(itemsubtotal);
    $("#salesitems-" + idx +"-total_amout").val(itemtotal); 


//Tax
$.each($(".cgst"), function() {
    cgst = cgst + Number($(this).val());
  });
$("#sales-cgst").val(cgst);

$.each($(".sgst"), function() {
    sgst = sgst + Number($(this).val());
  });
$("#sales-sgst").val(sgst);
  
$.each($(".igst"), function() {
    igst = igst + Number($(this).val());
  });
$("#sales-igst").val(igst);




$.each($(".totaltax"), function() {
    totaltax = totaltax + Number($(this).val());
  });
$("#sales-total_tax").val(totaltax);

$.each($(".itemsubtotal"), function() {
    subtotal = subtotal + Number($(this).val());
  });
$("#sales-sub_total").val(subtotal);

invoicetotal =subtotal+totaltax ;
$("#sales-invoice_amount").val(invoicetotal);

    
});


jQuery(".dynamicform_wrapper").on("afterInsert", function(e, item) {
    jQuery(".dynamicform_wrapper .panel-title-address").each(function(index) {
        jQuery(this).html("Product: " + (index + 1));
    });
});

jQuery(".dynamicform_wrapper").on("afterDelete", function(e) {
    jQuery(".dynamicform_wrapper .panel-title-address").each(function(index) {
        jQuery(this).html("Product: " + (index + 1));
    });
});


';

//$this->registerJs($js, $this::POS_HEAD);


$this->registerJs($script, $this::POS_READY);
?>
<style>
.form-control{padding:6px !important}
.help-block{display: none;}
.select2-selection__rendered{margin-top: 0 !important;}
.form-group.item-price{margin-bottom: 0;}
.item-price{visibility:hidden; height: 0;}
</style>
    
<div class="sales-form">
    <div class="box clearfix">
        <div class="box-body table-responsive">

            <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data', 'id' => 'dynamic-form']]); ?>
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-3">
                        <?php
//                        $form->field($model, 'customer_id')
                    $url = \yii\helpers\Url::to(['list-customers']);
                    
                    echo $form->field($model, 'user_id')->widget(Select2::classname(), [
                        'data' => Customers::getAllCustomers(),
                        'options' => ['placeholder' => 'Select A Customer'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ]
                    ]);                
                ?>
                    </div>
                    <!--<div class="col-md-3"><?= $form->field($model, 'invoice_number')->textInput(['maxlength' => true, 'disabled' => true]) ?></div>-->
                    <div class="col-md-3"> <?= $form->field($model, 'invoice_date')->widget(DatePicker::classname(), ['options' => ['placeholder' => 'Enter order date ...', 'autocomplete' => 'off'], 'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true, 'autoclose' => true,]]) ?></div>
                    <!--<div class="col-md-3"><?= $form->field($model, 'due_date')->textInput() ?></div>-->
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <?php
                        DynamicFormWidget::begin([
                            'widgetContainer' => 'dynamicform_wrapper', // required: only alphanumeric characters plus "_" [A-Za-z0-9_]
                            'widgetBody' => '.container-items', // required: css class selector
                            'widgetItem' => '.item', // required: css class
                            'limit' => 50, // the maximum times, an element can be cloned (default 999)
                            'min' => 1, // 0 or 1 (default 1)
                            'insertButton' => '.add-item', // css class
                            'deleteButton' => '.remove-item', // css class
                            'model' => $salesItems[0],
                            'formId' => 'dynamic-form',
                            'formFields' => [
                                'product_id',
                                'price',
                                'qty',
                            ],
                        ]);
                        ?>
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <i class="fa fa-envelope"></i> Items

                                <div class="clearfix"></div>
                            </div>
                            <div class="row">
                                <div class="panel-body container-items "><!-- widgetContainer -->
                                    <?php foreach ($salesItems as $index => $salesItem): ?>

                                        <div class="item col-md-12 event-list">
                                            <div class=" panel panel-default "><!-- widgetBody -->
                                                <div class="panel-heading">
                                                    <span class="panel-title-address">Product: <?= ( $index + 1 ) ?></span>
                                                    <div class="pull-right">
                                                        <button type="button" class="add-item btn btn-success btn-xs"><i class="glyphicon glyphicon-plus"></i></button>
                                                        <button type="button" class="remove-item btn btn-danger btn-xs"><i class="glyphicon glyphicon-minus"></i></button>
                                                    </div>
                                                    <div class="clearfix"></div>
                                                </div>
                                                <div class="panel-body">
                                                    <?php
                                                    // necessary for update action.

                                                    if (!$salesItem->isNewRecord) {
                                                        echo Html::activeHiddenInput($salesItem, "[{$index}]id");
                                                    }
                                                    ?>
                                                    <div class="row">
                                                        <div class="col-sm-4">
                                                            <?php
                                                            echo $form->field($salesItem, "[{$index}]product_id")->widget(Select2::classname(), [
                                                                'data' => Products::getAllProducts(),
                                                                'options' => ['placeholder' => 'Select Product', 'class'=>'change',
                                                                    'onchange'=>'$.post("list-product?id='.'"+$(this).val(), function(data){ $(event.target).closest(".row").find(".gst-percent").val(data); })'
                                                                    ],
                                                                'pluginOptions' => [
                                                                    'allowClear' => false
                                                                ]
                                                            ]);
                                                            ?>
                                                        </div>
                                                        <div class="col-sm-1">
                                                            <?= $form->field($salesItem, "[{$index}]qty")->textInput(['maxlength' => true, 'class' => 'form-control qty change']); ?>
                                                        </div>
                                                        <div class="col-sm-1">
                                                            <?= $form->field($salesItem, "[{$index}]mrp",['options' => ['class' => 'form-group item-mrp']])->textInput(['maxlength' => true, 'class' => 'form-control change mrp']); ?>
                                                            <?= $form->field($salesItem, "[{$index}]price",['options' => ['class' => 'form-group item-price']])->textInput(['maxlength' => true,'class' => 'form-control change price inprice']); ?>
                                                        </div>
<!--                                                        <div class="col-sm-2">
                                                            <div class="row">
                                                                <div class="col-md-4">
                                                                    <?= $form->field($salesItem, "[{$index}]gst_percent")->textInput(['readonly'=> true, 'class' => 'form-control change gst-percent']); ?>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <?= $form->field($salesItem, "[{$index}]sgst")->textInput(['readonly'=> true, 'class' => 'form-control sgst']); ?>
                                                                </div>
                                                                <div class="col-sm-4">
                                                                    <?= $form->field($salesItem, "[{$index}]cgst")->textInput(['readonly'=> true, 'class' => 'form-control cgst']); ?>
                                                                </div>
                                                            </div>
                                                        </div>-->

<!--                                                        <div class="col-sm-1">
                                                            <?= $form->field($salesItem, "[{$index}]total_tax")->textInput(['readonly'=> true, 'class' => 'form-control totaltax']); ?>
                                                        </div>-->
                                                        <div class="col-sm-1">
                                                            <?= $form->field($salesItem, "[{$index}]sub_total")->textInput(['readonly'=> true, 'class' => 'form-control itemsubtotal']); ?>
                                                        </div>
<!--                                                        <div class="col-sm-1">
                                                            <?= $form->field($salesItem, "[{$index}]total_amout")->textInput(['readonly'=> true, 'class' => 'form-control itemtotal']); ?>
                                                        </div>-->
<!--                                                        <div class="col-sm-2">
                                                            <?php
                                                                if((!$salesItem->isNewRecord) && $salesItem->is_taxincluded_price==1){
                                                                    echo $form->field($salesItem, "[{$index}]is_taxincluded_price")->checkBox(['label' => 'Gst included in Price', 'uncheck' => null, 'checked' => true, 'class' => 'includedgst change']);
                                                                }
                                                                else
                                                                {
                                                                    echo $form->field($salesItem, "[{$index}]is_taxincluded_price")->checkBox(['label' => 'Gst included in Price', 'uncheck' => null, 'checked' => false, 'class' => 'includedgst change']);
                                                                }
                                                                ?>
                                                        </div>-->
                                                    </div><!-- end:row -->

                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>    
                            </div>
                        </div>
                        <?php DynamicFormWidget::end(); ?>

                    </div>
                </div>


                <div class="row">
                    <div class="col-md-6">
                        <?= $form->field($model, 'notes')->textarea(['rows' => 6]) ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($model, 'private_notes')->textarea(['rows' => 6]) ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
<!--                        <div class="row">
                            <div class="col-md-6">
                                <div class="col-md-12"><?= $form->field($model, 'freight')->textInput() ?></div>
                            </div>
                            <div class="col-md-6">
                                <div class="col-md-12"><?= $form->field($model, 'round_off')->textInput(['class' => 'form-control change']) ?></div>
                            </div>
                        </div>-->
                    </div>
                    <div class="col-md-6">
                        <div class="row">
<!--                            <div class="col-md-6">
                                <div class="col-md-6"><?= $form->field($model, 'cgst')->textInput(['readonly'=> true]) ?></div>
                                <div class="col-md-6"><?= $form->field($model, 'sgst')->textInput(['readonly'=> true]) ?></div>
                                <div class="col-md-12"><?= $form->field($model, 'total_tax')->textInput(['readonly'=> true]) ?></div>
                            </div>-->
                            <div class="col-md-6">
                                <div class="col-md-6"><?= $form->field($model, 'sub_total')->textInput(['readonly'=> true]) ?></div>
                                <!--<div class="col-md-6"><?= $form->field($model, 'invoice_amount')->textInput(['readonly'=> true]) ?></div>-->
<!--                                <div class="col-md-6"><?= $form->field($model, 'amount_received')->textInput(['readonly'=> true]) ?></div>
                                <div class="col-md-6">////<?= $form->field($model, 'balance')->textInput(['readonly'=> true]) ?></div>-->
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                     <?= Html::submitButton($model->isNewRecord ? 'Create Sale' : 'Update Sale', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
                </div>
            </div>
        </div>
        <?php ActiveForm::end(); ?>

    </div>
    <?php
//$this->registerJs(
//        " $(document).ready(function () {
//        
//function calculate(idx){
//   $('#salesitems-' + idx +'-total_amout').val($('#salesitems-' + idx + '-qty').val() * $('#salesitems-' + idx +'-price').val());
//  }
//  
//function total() {
//  var sum = 0;
//  
//  $.each($('.sum'), function() {
//    sum = sum + Number($(this).val());
//  });
//  
//    $('#sales-sub_total').val(sum);
//  }
//        
//    });"
//);
    ?>