<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\PurchaseHistorySearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Purchase Histories';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="purchase-history-index">


    <p>
        <?= Html::a('Create Purchase History', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    'customer_id',
                    'product_id',
                    'purchased_on',
                    'added_by',
                    ['class' => 'yii\grid\ActionColumn'],
                ],
            ]);
            ?>
        </div>
    </div>

</div>
