<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use kartik\select2\Select2;
use yii\web\JsExpression;
/* @var $this yii\web\View */
/* @var $model common\models\PurchaseHistory */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="purchase-history-form">

    <?php $form = ActiveForm::begin(); ?>
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-6">
                        <?php
//                        $form->field($model, 'customer_id')
                        $url = \yii\helpers\Url::to(['list-customers']);
//                stop($url);
                echo $form->field($model, 'customer_id')->widget(Select2::classname(), [
                    'options' => ['multiple' => false, 'placeholder' => 'Search with Customer id, name or mobile number'],
                    'pluginOptions' => [
                        'allowClear' => true,
                        'minimumInputLength' => 3,
                        'language' => [
                            'errorLoading' => new JsExpression("function () { return 'Waiting for results...'; }"),
                        ],
                        'ajax' => [
                            'url' => $url,
                            'dataType' => 'json',
                            'data' => new JsExpression('function(params) { return {q:params.term}; }')
                        ],
                        'escapeMarkup' => new JsExpression('function (markup) { return markup; }'),
                        'templateResult' => new JsExpression('function(user) { return user.text; }'),
                        'templateSelection' => new JsExpression('function (user) { return user.text; }'),
                    ],
                ]); ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($model, 'product_id')->textInput() ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?= $form->field($model, 'purchased_on')->widget(DatePicker::classname(), ['options' => ['placeholder' => 'Enter event date ...', 'autocomplete' => 'off'], 'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true, 'autoclose' => true,]]) ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($model, 'added_by')->textInput() ?>
                    </div>
                </div>
                <div class="form-group col-md-12">
                     <?= Html::submitButton($model->isNewRecord ? 'Add Product To Customer' : 'Update Product History', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
                </div>

                <?php ActiveForm::end(); ?>

            </div>
        </div>
    </div>
</div>
