<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\components\Helper;
use common\models\ProductCategory;
use common\models\User;
use yii\helpers\Url;

$ProductCategory = Helper::getAllProductCatagory();
/* @var $this yii\web\View */
/* @var $searchModel common\models\ProductsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Products';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="products-index">


    <p>
        <?= Html::a('Create Products', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
//                    'id',
                    [
                        'attribute' => 'category',
                        'format' => 'raw',
                        'value' => function($data) {
                            $Catagory = Helper::getProductCatagoryDetails($data->category);
                            return $Catagory->cat_name;
                            //return Helper::getProductCatagoryDetails($data->category);
                        },
                        'filter' => Html::activeDropDownList($searchModel, 'category', ProductCategory::getHierarchy(), ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    'product_name',
//                    'pic',
                    'description:ntext',
                    'price',
                    [
                        'attribute' => 'status',
                        'format' => 'raw',
                        'value' => function($data) {
                            return $data->status == 0 ? Html::a('Inactive', 'Javascript:void(0)', ['class' => 'btn btn-xs btn-warning']) : Html::a('Active', 'Javascript:void(0)', ['class' => 'btn btn-xs btn-success']);
                        },
                        'filter' => Html::activeDropDownList($searchModel, 'status', ["1" => "Active", "0" => "Inactive"], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    ['class' => 'yii\grid\ActionColumn',
                        'headerOptions' => ['class' => 'action-column'],
                        'contentOptions' => ['style' => 'width:50px;'],
                        'header' => 'Actions',
                        'visible' => (Yii::$app->user->identity->role == (User::ROLE_ADMIN)),
                        'template' => '{view}{update}{delete}',
                        'visibleButtons' => [
                            'view' => false,
                            'update' => true,
                            'delete' => true,
                        ],
                        'buttons' => [
                            'view' => function ($url, $model) {
                                return Html::a('<div class="btn btn-success btn-flat btn-xs"><span class="glyphicon glyphicon-eye-open"></span></div>', $url, [
                                            'title' => Yii::t('app', 'customer-view'),
                                ]);
                            },
                                    'update' => function ($url, $model) {
                                return Html::a('<div class="btn btn-info btn-flat btn-xs"><span class="glyphicon glyphicon-pencil"></span> Edit</div>', $url, [
                                            'title' => Yii::t('app', 'customer-update'),
                                ]);
                            },
                                    'delete' => function ($url, $model) {
                                $url = Url::to(['products/delete', 'id' => $model->id]);
                                return Html::a('<div class="btn btn-danger btn-flat btn-xs"><span class="glyphicon glyphicon-trash"></span> Delete</div>', $url, [
                                            'title' => 'delete',
                                            'data-confirm' => Yii::t('yii', 'Are you sure you want to delete this item?'),
                                            'data-method' => 'post',
                                ]);
                            },
                                ],
                            ],
                ],
            ]);
            ?>

        </div>
    </div>
</div>
