<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Url;
use common\components\Helper;
use common\models\ProductCategory;
$ProductCategory = Helper::getAllProductCatagory();
/* @var $this yii\web\View */
/* @var $model common\models\Products */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="products-form">
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <?php $form = ActiveForm::begin(); ?>
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-md-6">
                                <?= $form->field($model, 'category')->dropDownList(ProductCategory::getHierarchy(), ['prompt' => 'Select Product Category...']); ?> 
                            </div>
                            <div class="col-md-6">
                                <?= $form->field($model, 'product_name')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?= $form->field($model, 'description')->textarea(['rows' => 6]) ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?= $form->field($model, 'price')->textInput() ?>
                            </div>
                            <div class="col-md-6">
                                <?= $form->field($model, 'status')->dropDownList(['1' => 'Active', '0' => 'Inactive'], ['prompt' => 'Select Status']) ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $upload_path = Url::to('@common/../uploads/');
                        echo $form->field($model, '_pic')->widget(\bilginnet\cropper\Cropper::className(), [
                            'cropperOptions' => [
                                'width' => 500, // must be specified
                                'height' => 500, // must be specified
                                'preview' => [
                                    'url' => (!empty($model->pic)) ? Url::base(true) . "/uploads/products/" . $model->pic : '', // (!empty($model->image)) ? Yii::getAlias('@uploadUrl/'.$model->image) : null
                                    'width' => 300, // must be specified // you can set as string '100%'
                                    'height' => 300, // must be specified // you can set as string '100px'
                                ],
                                'buttonCssClass' => 'btn btn-default',
                            ]
                        ]);
                        ?>
                    </div>
                </div>
            </div>
            <div class="form-group col-md-12">
                <?= Html::submitButton($model->isNewRecord ? 'Save Product' : 'Update Product', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>
