<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use common\components\Helper;
/* @var $this yii\web\View */
/* @var $searchModel common\models\ProductCategorysSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Product Categories';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="product-category-index">


    <p>
        <?= Html::a('Create Product Category', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    'cat_name',
                    [
                        'attribute' => 'parrent_id',
                        'format' => 'raw',
                        'value' => function($data) {
                        $Catagory = Helper::getProductCatagoryDetails($data->parrent_id);
                        if($data->parrent_id == 0){
                            return "Main Catagory";
                        }
                        else{
                            return $Catagory->cat_name;
                        }
                        
                        },
                        'filter'=>false, 
//                                
                    ],
                    
                    
                    ['class' => 'yii\grid\ActionColumn',
                        'headerOptions' => ['class' => 'action-column'],
                        'contentOptions' => ['style' => 'width:50px;'],
                        'header' => 'Actions',
                        'visible' => (Yii::$app->user->identity->role == (User::ROLE_ADMIN)),
                        'template' => '{view}{update}{delete}',
                        'visibleButtons' => [
                            'view' => false,
                            'update' => true,
                            'delete' => false,
                        ],
                        'buttons' => [
                            'view' => function ($url, $model) {
                                return Html::a('<div class="btn btn-success btn-flat btn-xs"><span class="glyphicon glyphicon-eye-open"></span></div>', $url, [
                                            'title' => Yii::t('app', 'customer-view'),
                                ]);
                            },
                                    'update' => function ($url, $model) {
                                return Html::a('<div class="btn btn-info btn-flat btn-xs"><span class="glyphicon glyphicon-pencil"></span> Edit</div>', $url, [
                                            'title' => Yii::t('app', 'customer-update'),
                                ]);
                            },
                                    'delete' => function ($url, $model) {
                                return Html::a('<div class="btn btn-danger btn-flat btn-xs"><span class="glyphicon glyphicon-trash"></span></div>', $url, [
                                            'title' => Yii::t('app', 'customer-delete'),
                                ]);
                            }
                                ],
                            ],
                        ],
                    ]);
                    ?>

        </div>
    </div>
</div>
