<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use common\models\ProductCategory;
use common\models\Amenities;

/* @var $this yii\web\View */
/* @var $model common\models\Category */
/* @var $form yii\widgets\ActiveForm */
?>

<style>
    .category-form ul{padding: 0; background: #fff;}
    .category-form    ul li {
        font-weight: normal;
        font-size: 16px;
        padding: 10px 30px;
        margin-bottom: 18px;
        list-style: none;
        display: inline-block;
        margin: 0;
        text-align: center;
        border-right: solid 1px;
        border-bottom: solid 1px;
    }
    .category-form ul li [class^="icon-"], ul li [class*=" icon-"] {
        font-size: 30px;
        margin-bottom: 5px;
        display: block;
        padding: 0 35px;
    }
    input[type="checkbox"] {
        padding: 0;
        height: initial;
        width: initial;
        margin-bottom: 0;
        display: none;
        cursor: pointer;
    }
    .category-form ul li {
        position: relative;
        cursor: pointer;
    }
    .category-form ul input:checked + li{background-color: #2E8B57; color: #fff;}
    .field-category-amenities.has-success label{color:#000;}
    #category-amenities{margin-top: 10px;}
</style>
<div class="category-form">
<?php $form = ActiveForm::begin(); ?>
    <div class="box box-default">
        <!-- /.box-header -->
        <div class="box-body">
            <div class="col-md-6">
            <?= $form->field($model, 'cat_name')->textInput(['maxlength' => true])->label('Category Name') ?>
            </div>
            <div class="col-md-6"> 
                <?php
                $datamain = ['0' => 'Main category'];
                $dataCategory = ArrayHelper::map(ProductCategory::find()->where(['parrent_id' => 0])->all(), 'id', 'cat_name');
                $category = ArrayHelper::merge($datamain, $dataCategory);
                
                echo $form->field($model, 'parrent_id')->dropDownList($category, ['prompt' => '-Choose a Category-']);
                ?>
            </div>
            
            
            <div class="form-group col-md-12">
<?= Html::submitButton($model->isNewRecord ? 'Save Category' : 'Update Category', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
            </div>
        </div>
    </div>
<?php ActiveForm::end(); ?>

</div>
