<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use common\components\Helper;
use common\models\Staffs;
use common\models\Services;
use kartik\daterange\DateRangePicker;
/* @var $this yii\web\View */
/* @var $searchModel common\models\PaymentsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Payments';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="payments-index">
<div class="box clearfix">
        <div class="box-body table-responsive">
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'id',
            'service_id',

            [
                'attribute' => 'service_id',
                'headerOptions' => ['style' => 'width:150px'],
                'value' => function($data) {
                    $service = Services::findOne($data->service_id);
                    $service_number = $service->service_number;
                    return Html::a($service_number, ['services/view?id=' . $data->service_id], ['class' => 'btn btn-info btn-flat']);
                },
                'format' => 'raw'
            ],
            'note:ntext',
            'amount',
            [
                'attribute' => 'transaction_date',
                 'contentOptions' => ['style' => 'width: 225px;'],
                'format' => 'raw',
                'value' => function($data) {
                   return $data->transaction_date;
                },
                'filter' => DateRangePicker::widget([
                'model' => $searchModel,
                'name' => 'expiry',
                'attribute' => 'transaction_date',
                'presetDropdown'=>true,   
                'hideInput'=>true,
                'convertFormat'=>true,
                'pluginOptions' => [
                    'opens'=>'right',
                    'locale' => [
//                        'cancelLabel' => 'Clear',
                        'format' => 'Y-m-d',
                ]
                    
                    ],
            ]),
            ],
            //'created_by',
            [
                'attribute' => 'created_by',
                'format' => 'raw',
                'value' => function($data) {
                        return Helper::getNameFromID($data->created_by);
                },
               'filter' => Html::activeDropDownList($searchModel, 'created_by', Staffs::getAllStaffs(), ['class' => 'form-control', 'prompt' => 'Select All']),
            ],
            //'created_at',

            // ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>

</div>
