<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use yii\helpers\Url;
/* @var $this yii\web\View */
/* @var $searchModel common\models\OrdersSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Orders';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="orders-index">
    <p>
<?= Html::a('Create Orders', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

<?php // echo $this->render('_search', ['model' => $searchModel]);  ?>
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'rowOptions' => function ($model) {
                    if ($model->status == 'Cancelled') {
                        return ['class' => 'bg-red disabled'];
                    }
                },
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],
//                    'id',
                            'order_number',
                            ['attribute' => 'customer_id',
                                'value' => 'customer.name',
                                'filter' => false
                            ],
                            'order_date',
                            'created_at',
                            //'created_by',
                            //'status',
                            ['label' => 'Items',
                                'format' => 'raw',
                                'visible' => (Yii::$app->user->identity->role == (User::ROLE_ADMIN)),
                                'value' => function ($data) {
                                    return Html::a(Html::encode("Manage"), '@web/order-items?order-id=' . $data['id']);
                                }
                            ],
                            ['label' => ' ',
                                'format' => 'raw',
                                'visible' => (Yii::$app->user->identity->role == (User::ROLE_ADMIN || User::ROLE_STAFF)),
                                'value' => function ($data) {
                                    return Html::a(Html::encode("View Items"), '@web/order-items/view/?order-id=' . $data['id']);
                                }
                            ],
//                            ['class' => 'yii\grid\ActionColumn'],
                                    ['class' => 'yii\grid\ActionColumn',
                        'headerOptions' => ['class' => 'action-column'],
                        'contentOptions' => ['style' => 'width:50px;'],
                        'header' => 'Actions',
                        'visible' => (Yii::$app->user->identity->role == (User::ROLE_ADMIN)),
                        'template' => '{view}{update}{delete}',
                        'visibleButtons' => [
                            'view' => false,
                            'update' => false,
                            'delete' => true,
                        ],
                        'buttons' => [
                            'view' => function ($url, $model) {
                                return Html::a('<div class="btn btn-success btn-flat btn-xs"><span class="glyphicon glyphicon-eye-open"></span></div>', $url, [
                                            'title' => Yii::t('app', 'customer-view'),
                                ]);
                            },
                                    'update' => function ($url, $model) {
                                return Html::a('<div class="btn btn-info btn-flat btn-xs"><span class="glyphicon glyphicon-pencil"></span> Edit</div>', $url, [
                                            'title' => Yii::t('app', 'customer-update'),
                                ]);
                            },
                                    'delete' => function ($url, $model) {
                                $url = Url::to(['orders/delete', 'id' => $model->id]);
                                return Html::a('<div class="btn btn-danger btn-flat btn-xs"><span class="glyphicon glyphicon-trash"></span> Delete</div>', $url, [
                                            'title' => 'delete',
                                            'data-confirm' => Yii::t('yii', 'Are you sure you want to delete this item?'),
                                            'data-method' => 'post',
                                ]);
                            },
                                ],
                            ],
                        ],
                    ]);
                    ?>
        </div>
    </div>

</div>
