<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use kartik\select2\Select2;
use yii\web\JsExpression;
use common\models\Customers;
/* @var $this yii\web\View */
/* @var $model common\models\Orders */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="orders-form">
    <?php $form = ActiveForm::begin(['options' => ['id' => 'orders-form']]); ?>
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-7">
                        <?php
//                        $form->field($model, 'customer_id')
                    $url = \yii\helpers\Url::to(['list-customers']);
                    
                    echo $form->field($model, 'customer_id')->widget(Select2::classname(), [
                        'data' => Customers::getAllCustomers(),
                        'options' => ['placeholder' => 'Select A Customer'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ]
                    ]);
//                        echo $form->field($model, 'customer_id')->dropDownList(Customers::getAllCustomers(), ['prompt' => 'Select Product Category...']); 
//                stop($url);
//                echo $form->field($model, 'customer_id')->widget(Select2::classname(), [
//                    'options' => ['multiple' => false, 'placeholder' => 'Search with Customer id, name or mobile number'],
//                    'pluginOptions' => [
//                        'allowClear' => true,
//                        'minimumInputLength' => 3,
//                        'language' => [
//                            'errorLoading' => new JsExpression("function () { return 'Waiting for results...'; }"),
//                        ],
//                        'ajax' => [
//                            'url' => $url,
//                            'dataType' => 'json',
//                            'data' => new JsExpression('function(params) { return {q:params.term}; }')
//                        ],
//                        'escapeMarkup' => new JsExpression('function (markup) { return markup; }'),
//                        'templateResult' => new JsExpression('function(user) { return user.text; }'),
//                        'templateSelection' => new JsExpression('function (user) { return user.text; }'),
//                    ],
//                ]); 
                
                ?>
                    </div>
                    <div class="col-md-5">
                        <?= $form->field($model, 'order_date')->widget(DatePicker::classname(), ['options' => ['placeholder' => 'Enter order date ...', 'autocomplete' => 'off'], 'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true, 'autoclose' => true,]]) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-md-12">
                        <?= Html::submitButton($model->isNewRecord ? 'Create Order' : 'Update Order', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php ActiveForm::end(); ?>
</div>
<?php
$this->registerJs(
        " $(document).ready(function () {
        $('#orders-form').on('beforeSubmit', function (e) {
            $('.btn').addClass('disabled');
        });
    });"
);
?>