<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\GridView;
use common\components\Helper;
use common\models\User;
use common\models\ProductCategory;

$ProductCategory = Helper::getAllProductCatagory();
/* @var $this yii\web\View */
/* @var $searchModel common\models\OrderItemsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Order Items';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="order-items-index">
    <p>
<?= Html::a('Create Order Items', ['create?order-id=' . $searchModel->order_id], ['class' => 'btn btn-success']) ?>
    </p>

<?php // echo $this->render('_search', ['model' => $searchModel]);  ?>
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
//                    'id',
//                    'order_id',
                    
                                [
                        'attribute' => 'product_cat',
                        'format' => 'raw',
                        'value' => function($data) {
                            $Catagory = Helper::getProductCatagoryDetails($data->product_cat);
                            return $Catagory->cat_name;
                            //return Helper::getProductCatagoryDetails($data->category);
                        },
                        'filter' => Html::activeDropDownList($searchModel, 'product_cat', ProductCategory::getHierarchy(), ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    [
                        'attribute' => 'product_id',
                        'format' => 'raw',
                        'value' => function($data) {
                            $product = Helper::getProductDetails($data->product_id);
                            return $product->product_name;
                        },
                        'filter' => false,
                    ],
//                    'product_id',
                    'range',
                    'qty',
                    'price',
                    'total',
                    //'next_billing_date',
                    //'status',
                    ['class' => 'yii\grid\ActionColumn',
                        'headerOptions' => ['class' => 'action-column'],
                        'contentOptions' => ['style' => 'width:50px;'],
                        'header' => 'Actions',
                        'visible' => (Yii::$app->user->identity->role == (User::ROLE_ADMIN)),
                        'template' => '{view}{update}{delete}',
                        'visibleButtons' => [
                            'view' => false,
                            'update' => false,
                            'delete' => true,
                        ],
                        'buttons' => [
                            'view' => function ($url, $model) {
                                return Html::a('<div class="btn btn-success btn-flat btn-xs"><span class="glyphicon glyphicon-eye-open"></span></div>', $url, [
                                            'title' => Yii::t('app', 'customer-view'),
                                ]);
                            },
                                    'update' => function ($url, $model) {
                                return Html::a('<div class="btn btn-info btn-flat btn-xs"><span class="glyphicon glyphicon-pencil"></span> Edit</div>', $url, [
                                            'title' => Yii::t('app', 'customer-update'),
                                ]);
                            },
                                    'delete' => function ($url, $model) {
                                $url = Url::to(['order-items/delete', 'id' => $model->id, 'order-id' => $model->order_id]);
                                return Html::a('<div class="btn btn-danger btn-flat btn-xs"><span class="glyphicon glyphicon-trash"></span> Delete</div>', $url, [
                                            'title' => 'delete',
                                            'data-confirm' => Yii::t('yii', 'Are you sure you want to delete this item?'),
                                            'data-method' => 'post',
                                ]);
                            },
                                ],
                            ],
                        ],
                    ]);
                    ?>

        </div>
    </div>
</div>
