<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\components\Helper;
use common\models\ProductCategory;
use kartik\select2\Select2;
use kartik\depdrop\DepDrop;
use yii\helpers\Url;
use common\models\Products;
$ProductCategory = Helper::getAllProductCatagory();
/* @var $this yii\web\View */
/* @var $model common\models\OrderItems */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="order-items-form">
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <?php $form = ActiveForm::begin(); ?>
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-3">
                        <?php
                        echo Html::hiddenInput('model-product-id', $model->product_id, ['id' => 'model-product-id']);
                            $items = ProductCategory::getHierarchy();
                            echo $form->field($model, 'product_cat')->widget(Select2::classname(), [
                                'data' => $items,
                                'options' => ['placeholder' => 'Select a Category ...', 'id' => 'cat-id'],
                                'pluginOptions' => [
                                    'tags' => false,
                                    'tokenSeparators' => [',']
                                ]
                            ]);
                            ?>
                    </div>
                    <div class="col-md-3">
                        <?php
                            echo $form->field($model, 'product_id')->widget(DepDrop::classname(), [
                                'options' => ['id' => 'product-id'],
                                'type' => DepDrop::TYPE_SELECT2,
                                'pluginOptions' => [
                                    'depends' => ['cat-id'],
                                    'initialize' => ($model->isNewRecord) ? false : true,
                                    'initDepends' => ['cat-id'],
                                    'placeholder' => 'Select Product',
                                    'url' => Url::to(['/product-category/products']),
                                    'params' => ['model-product-id'],
                                    'loadingText' => 'Loading Products...'
                                ]
                            ]);
                            ?>
                        
                    </div>
                    <div class="col-md-2">
                        <?= $form->field($model, 'range')->textInput() ?>
                    </div>
                    <div class="col-md-2">
                        <?= $form->field($model, 'qty')->dropDownList(['1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5', '6' => '6', '7' => '7', '8' => '8', '9' => '9', '10' => '10'], ['prompt' => 'Select Qty']) ?>
                    </div>
                    <div class="col-md-2">
                        <?= $form->field($model, 'price')->textInput() ?>
                    </div>
                    
                </div>
            </div>
            <div class="form-group col-md-12">
                <?= Html::submitButton('Add Product to Order items', ['class' => 'btn btn-success']) ?>
            </div>

            <?php ActiveForm::end(); ?>

        </div>
