<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use common\components\Helper;
use common\models\Staffs;
$role = Yii::$app->user->identity->role;
/* @var $this yii\web\View */
/* @var $searchModel common\models\LeadsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Leads';
$this->params['breadcrumbs'][] = $this->title;
$districts = Helper::getAllDistricts();
?>
<div class="leads-index">

    <p>
        <?= Html::a('Create Leads', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="box clearfix">
        <div class="box-body table-responsive">
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'id',
            'name',
            'phone',
            'email:email',
            // 'follow_up',
            [
                'attribute' => 'follow_up',
                'format' => 'raw',
                'value' => function($data) {
                    return date("d-m-Y", strtotime($data->follow_up));
                        
                },
            ],
            [
                'attribute' => 'lead_from',
                'format' => 'raw',
                'value' => function($data) {
                    if($data->lead_from== 1){
                        return "Website";
                    }
                    else {
                        return "Direct";
                    }
                        
                },
            ],
            // 'note:ntext',
            [
                'attribute' => 'added_by',
                'format' => 'raw',
                'visible' => (($role == User::ROLE_ADMIN)) ? true : false,
                'value' => function($data) {
                    if($data->added_by==0){
                        return "Website";
                    }
                    else {
                        return Helper::getNameFromID($data->added_by);
                    }
                        
                },
                'filter' => Html::activeDropDownList($searchModel, 'added_by', Staffs::getAllStaffs(), ['class' => 'form-control', 'prompt' => 'Select All']),
            ],
            [
                'attribute' => 'Verify',
                'format' => 'raw',
                'visible' => (Yii::$app->user->identity->role == User::ROLE_ADMIN ) ? true : false,
                'value' => function($data) {
                    return $data->status == 1 ? Html::a('Inactive', ['leads/statusupdate/?id=' . $data->id], ['class' => 'btn btn-xs btn-info']) : '';
                },
            ],
            [
                'attribute' => 'district',
                'format' => 'raw',
                'value' => function($data) {
                    return Helper::getDistrict($data->district);
                },
                'filter' => Html::activeDropDownList($searchModel, 'district', $districts, ['class' => 'form-control', 'prompt' => 'Select All']),
            ],
            [
                'attribute' => 'status',
                'format' => 'raw',
                'visible' => (($role == User::ROLE_ADMIN) || ($role == User::ROLE_STAFF)) ? true : false,            
                'value' => function($data) {
                    if($data->status == 0){
                        return  Html::a('Pending', 'Javascript:void(0)', ['class' => 'btn btn-xs btn-warning']);
                    }
                    else if($data->status == 1){
                        return  Html::a('Pending Verification', 'Javascript:void(0)', ['class' => 'btn btn-xs btn-info']);
                    }
                    else if($data->status == 2){
                        return  Html::a('Closed', 'Javascript:void(0)', ['class' => 'btn btn-xs btn-success']);
                    }
                    else if($data->status == 4){
                        return  Html::a('Processing', 'Javascript:void(0)', ['class' => 'btn btn-xs btn-success']);
                    }
                    else{
                            return  Html::a('Cancelled', 'Javascript:void(0)', ['class' => 'btn btn-xs btn-danger']);
                    }
                },
                'filter' => Html::activeDropDownList($searchModel, 'status', ['0' => 'Pending','4' => 'Processing' , '1' => 'Closed for verify', '2' => 'Closed', '3' => 'Cancelled'], ['class' => 'form-control', 'prompt' => 'Select All']),
            ],

            ['class' => 'yii\grid\ActionColumn',
                        'headerOptions' => ['class' => 'action-column'],
                        'contentOptions' => ['style' => 'width:50px;'],
                        'header' => 'Actions',
                        'visible' => (Yii::$app->user->identity->role == (User::ROLE_ADMIN || User::ROLE_STAFF)) ? true : false,
                        'template' => '{view}{update}{delete}',
                        'visibleButtons' => [
                            'view' => false,
                            'update' => true,
                            'delete' => false,
                        ],
                        'buttons' => [
                                'view' => function ($url, $model) {
                                    return Html::a('<div class="btn btn-success btn-flat btn-xs"><span class="glyphicon glyphicon-eye-open"></span> View</div>', $url, [
                                                'title' => Yii::t('app', 'customer-view'),
                                    ]);
                                },
                                'update' => function ($url, $model) {
                                    return Html::a('<div class="btn btn-info btn-flat btn-xs"><span class="glyphicon glyphicon-pencil"></span> Update</div>', $url, [
                                                'title' => Yii::t('app', 'customer-update'),
                                    ]);
                                },
                        ],
                    ],
        ],
    ]); ?>
</div>
</div>




</div>
