<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\components\Helper;
use kartik\date\DatePicker;
/* @var $this yii\web\View */
/* @var $model common\models\Leads */
/* @var $form yii\widgets\ActiveForm */
$districts = Helper::getAllDistricts();
?>

<div class="leads-form">

    <?php $form = ActiveForm::begin(); ?>
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-4">
                        <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-4">
                        <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-4">
                        <?= $form->field($model, 'follow_up')->widget(DatePicker::classname(), ['options' => ['placeholder' => 'Enter order date ...', 'autocomplete' => 'off'], 'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true, 'autoclose' => true,]]) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?= $form->field($model, 'phone')->textInput() ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($model, 'district')->dropDownList($districts, ['prompt' => 'Select District...']);?> 
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                    <?= $form->field($model, 'note')->textarea(['rows' => 6]) ?>
                    </div>
                </div>
                <?php if(!$model->isNewRecord){ ?>
                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'status')->dropDownList(['0' => 'Pending', '4' => 'Processing' ,'1' => 'Closed for verify', '3' => 'Cancelled'], ['prompt' => 'Select Status']) ?>
                        </div>
                    </div>
                <?php
                }
                ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
