<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use yii\grid\GridView;
use common\models\User;
use common\models\Staffs;
use kartik\daterange\DateRangePicker;
use common\components\Helper;
/* @var $this yii\web\View */
/* @var $model common\models\Customers */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => 'Customers', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="customers-view">

    <div class="row">
          <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box">
              <span class="info-box-icon bg-info"><i class="far fa-envelope"></i></span>

              <div class="info-box-content">
                <span class="info-box-text">Servicess Provided</span>
                <span class="info-box-number">1,410</span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>
          <!-- /.col -->
          <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box">
              <span class="info-box-icon bg-success"><i class="far fa-flag"></i></span>

              <div class="info-box-content">
                <span class="info-box-text">Paid Services Amount</span>
                <span class="info-box-number">410</span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>
          <!-- /.col -->
          <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box">
              <span class="info-box-icon bg-warning"><i class="far fa-copy"></i></span>

              <div class="info-box-content">
                <span class="info-box-text">Unpaid  Services Amount</span>
                <span class="info-box-number">13,648</span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>
          <!-- /.col -->
          <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box">
              <span class="info-box-icon bg-danger"><i class="far fa-star"></i></span>

              <div class="info-box-content">
                <span class="info-box-text">Likes</span>
                <span class="info-box-number">93,139</span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>
          <!-- /.col -->
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="box box-success">
                <div class="box-header">
                    <i class="fa fa-comments-o"></i>
                    <h3 class="box-title">Services</h3>
                </div>
                <div class="box-body">
                    <?=
                    GridView::widget([
                        'dataProvider' => $services,
                        'filterModel' => $servicessearchModel,
                        'rowOptions' => function ($model) {
                            if ($model->payment_status == '0') {
                                return ['class' => 'bg-red disabled'];
                            }
                        },
                                'columns' => [
                                    ['class' => 'yii\grid\SerialColumn'],
//                    'id',
                                        [
                                            'attribute' => 'service_type',
                                            'format' => 'raw',
                                            'value' => function($data) {
                                                    return $data->service_type;
                                            },
                                            'filter' => Html::activeDropDownList($servicessearchModel, 'service_type', ["Customisation" => "Customisation", "Renewal" => "Renewal", "New Purchase" => "New Purchase"], ['class' => 'form-control', 'prompt' => 'Select All']),
                                        ],
                                        [
                                            'attribute' => 'service_mode',
                                            'format' => 'raw',
                                            'value' => function($data) {
                                                    return $data->service_mode;
                                            },
                                            'filter' => Html::activeDropDownList($servicessearchModel, 'service_mode', ["AMC" => "AMC", "Paid" => "Paid", "Free" => "Free"], ['class' => 'form-control', 'prompt' => 'Select All']),
                                        ],
                                        [
                                            'attribute' => 'total_amount',
                                            'format' => 'raw',
                                            'visible' => (Yii::$app->user->identity->role == User::ROLE_ADMIN ) ? true : false,
                                            'value' => function($data) {
                                                    return $data->total_amount;
                                            },
                                            // 'filter' => false
                                        ],
                                        [
                                            'attribute' => 'payment_status',
                                            'format' => 'raw',
                                            'value' => function($data) {
                                                    if($data->payment_status==1){
                                                        return "Paid";
                                                    }
                                                    else{
                                                        return  Html::a(Yii::t('app', ' {modelClass}', [
                                                            'modelClass' => 'Unpaid',
                                                            ]), ['services/payment','id'=>$data->id], ['class' => 'btn btn-success popupModal btn-flat btn-xs']);
                                                    }
                                            },
                                            'filter' => Html::activeDropDownList($servicessearchModel, 'payment_status', ["1" => "Paid", "0" => "Un Paid"], ['class' => 'form-control', 'prompt' => 'Select All']),
                                        ],
                                        [
                                            'attribute' => 'call_type',
                                            'format' => 'raw',
                                            'visible' => (Yii::$app->user->identity->role == User::ROLE_ADMIN ) ? true : false,
                                            'value' => function($data) {
                                                    return $data->call_type;
                                            },
                                            'filter' => Html::activeDropDownList($servicessearchModel, 'call_type', ["inbound" => "In Bound", "outbound" => "Out Bound"], ['class' => 'form-control', 'prompt' => 'Select All']),
                                        ],
                                        [
                                            'attribute' => 'attended_by',
                                            'format' => 'raw',
                                            'visible' => (Yii::$app->user->identity->role == User::ROLE_ADMIN ) ? true : false,
                                            'value' => function($data) {
                                                    return Helper::getNameFromID($data->attended_by);
                                            },
                                        'filter' => Html::activeDropDownList($servicessearchModel, 'attended_by', Staffs::getAllStaffs(), ['class' => 'form-control', 'prompt' => 'Select All']),
                                        ],
                                        [
                                            'attribute' => 'completion_date',
                                            'contentOptions' => ['style' => 'width: 225px;'],
                                            'format' => 'raw',
                                            'value' => function($data) {
                                            return $data->completion_date;
                                            },
                                            'filter' => DateRangePicker::widget([
                                            'model' => $servicessearchModel,
                                            'name' => 'expiry',
                                            'attribute' => 'completion_date',
                                            'presetDropdown'=>true,   
                                            'hideInput'=>true,
                                            'convertFormat'=>true,
                                            'pluginOptions' => [
                                                'opens'=>'right',
                                                'locale' => [
                                        //                        'cancelLabel' => 'Clear',
                                                    'format' => 'Y-m-d',
                                            ]
                                                
                                                ],
                                        ]),
                                        ],
                                        'created_at',
                                        [
                                            'attribute' => 'status',
                                            'format' => 'raw',
                                            'value' => function($data) {
                                                    return $data->status;
                                            },
                                            'filter' => Html::activeDropDownList($servicessearchModel, 'status', ["Pending" => "Pending", "On Progress" => "On Progress", "Completed" => "Completed", "Cancelled" => "Cancelled"], ['class' => 'form-control', 'prompt' => 'Select All']),
                                        ],
//                                    'created_at',
                                    //'created_by',
                                    
//                            ['class' => 'yii\grid\ActionColumn'],
                                ],
                            ]);
                            ?>

                </div>
            </div>
        </div>
    </div>

</div>
