<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use common\components\Helper;

/* @var $this yii\web\View */
/* @var $searchModel common\models\CustomersSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Customers';
$this->params['breadcrumbs'][] = $this->title;
$districts = Helper::getAllDistricts();
?>
<div class="customers-index">
    <p>
<?= Html::a('Create Customer', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

<?php // echo $this->render('_search', ['model' => $searchModel]);  ?>
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    'customer_id',
                    'company',
                    'serial_number',
                    'name',
                    'mobile',
                    'email:email',
                    [
                        'attribute' => 'district',
                        'format' => 'raw',
                        'value' => function($data) {
                            return Helper::getDistrict($data->district);
                        },
                        'filter' => Html::activeDropDownList($searchModel, 'district', $districts, ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    [
                        'attribute' => 'added_by',
                        'format' => 'raw',
                        'visible' => (Yii::$app->user->identity->role == User::ROLE_ADMIN ) ? true : false,
                        'value' => function($data) {
                                return Helper::getNameFromID($data->added_by);
//                            else{
//                                 return "Distributor CLient";
//                            }
                        },
//                         'filter' => false        
//                        'filter' => Html::activeDropDownList($searchModel, 'added_by', ['20'=>'Admin - Direct CLient','30'=>'Staff - Direct CLient','40'=>'Distributor CLient',], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    
                    [
                        'attribute' => 'status',
                        'format' => 'raw',
                        'visible' => (Yii::$app->user->identity->role == User::ROLE_ADMIN ) ? true : false,            
                        'value' => function($data) {
                            return $data->status == 0 ? Html::a('Inactive', 'Javascript:void(0)', ['class' => 'btn btn-xs btn-warning']) : Html::a('Active', 'Javascript:void(0)', ['class' => 'btn btn-xs btn-success']);
                        },
                        'filter' => Html::activeDropDownList($searchModel, 'status', ["1" => "Active", "0" => "Inactive"], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    ['class' => 'yii\grid\ActionColumn',
                        'headerOptions' => ['class' => 'action-column'],
                        'contentOptions' => ['style' => 'width:50px;'],
                        'header' => 'Actions',
                        'visible' => (Yii::$app->user->identity->role == (User::ROLE_ADMIN || User::ROLE_STAFF)) ? true : false,
                        'template' => '{view}{update}{delete}',
                        'visibleButtons' => [
                            'view' => true,
                            'update' => true,
                            'delete' => false,
                        ],
                        'buttons' => [
                                        'view' => function ($url, $model) {
                                            if(Yii::$app->user->identity->role == (User::ROLE_ADMIN))
                                            {
                                                return Html::a('<div class="btn btn-success btn-flat btn-xs"><span class="glyphicon glyphicon-eye-open"></span> View</div>', $url, [
                                                            'title' => Yii::t('app', 'customer-view'),
                                                ]);
                                            }
                                        },
                                        'update' => function ($url, $model) {
                                            return Html::a('<div class="btn btn-info btn-flat btn-xs"><span class="glyphicon glyphicon-pencil"></span> Edit</div>', $url, [
                                                        'title' => Yii::t('app', 'customer-update'),
                                            ]);
                                        },
                                        'delete' => function ($url, $model) {
                                            return Html::a('<div class="btn btn-danger btn-flat btn-xs"><span class="glyphicon glyphicon-trash"></span></div>', $url, [
                                                        'title' => Yii::t('app', 'customer-delete'),
                                            ]);
                                        }
                            ],
                            ],
                        ],
                    ]);
                    ?>

        </div>
    </div>
</div>
