<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\components\Helper;
/* @var $this yii\web\View */
/* @var $model common\models\Customers */
/* @var $form yii\widgets\ActiveForm */
$districts = Helper::getAllDistricts();
?>

<div class="customers-form">
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <?php $form = ActiveForm::begin(); ?>
            <div class"col-md-12">
                <!-- <div class="row"> -->
                    <div class="col-md-12">
                        <?= $form->field($model, 'company')->textInput(['maxlength' => true]) ?>
                    </div>

                    <div class="col-md-6">
                        <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($model, 'mobile')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($model, 'serial_number')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($model, 'district')->dropDownList($districts, ['prompt' => 'Select District...']);?> 
                    </div>
                    <?php
                    if(!$model->isNewRecord){
                        ?>
                    <div class="col-md-6">
                                <?= $form->field($model, 'status')->dropDownList(['1' => 'Active', '0' => 'Inactive'], ['prompt' => 'Select Status']) ?>
                            </div>
                    <?php
                    }
                    ?>
                    <div class="form-group col-md-12">
                        <?= Html::submitButton($model->isNewRecord ? 'Create Customer' : 'Update Customer', ['class' => $model->isNewRecord ? 'btn btn-success create-btn' : 'btn btn-primary create-btn']) ?>
                    </div>
                <!-- </div> -->
            </div>
            <?php ActiveForm::end(); ?>

        </div>
    </div>
</div>