<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\models\User;
use common\models\Staffs;
use common\components\Helper;
use kartik\daterange\DateRangePicker;
/* @var $this yii\web\View */
/* @var $searchModel common\models\AmcSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Amcs';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="amc-index">


     <p>
        <?= Html::a('Create Amc', ['create'], ['class' => 'btn btn-success']) ?>
    </p> 

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    <div class="box clearfix">
        <div class="box-body table-responsive">
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'id',
            ['attribute' => 'user_id',
                                'value' => 'customer.company',
                                'filter' => false
                            ],
            [
                'attribute' => 'expiry',
                 'contentOptions' => ['style' => 'width: 225px;'],
                'format' => 'raw',
                'value' => function($data) {
                   return date("d-m-Y", strtotime($data->expiry));
                },
                'filter' => DateRangePicker::widget([
                'model' => $searchModel,
                'name' => 'expiry',
                'attribute' => 'expiry',
                'presetDropdown'=>true,   
                'hideInput'=>true,
                'convertFormat'=>true,
//                'startAttribute'=>'datetime_min',
//                'endAttribute'=>'datetime_max',    
                'pluginOptions' => [
                    'opens'=>'right',
                    'locale' => [
//                        'cancelLabel' => 'Clear',
                        'format' => 'Y-m-d',
                ]
                    
                    ],
            ]),
            ],
            [
                'attribute' => 'created_by',
                'format' => 'raw',
                'visible' => (Yii::$app->user->identity->role == User::ROLE_ADMIN ) ? true : false,
                'value' => function($data) {
                        return Helper::getNameFromID($data->created_by);
                },
               'filter' => Html::activeDropDownList($searchModel, 'created_by', Staffs::getAllStaffs(), ['class' => 'form-control', 'prompt' => 'Select All']),
            ],
            ['class' => 'yii\grid\ActionColumn',
                        'headerOptions' => ['class' => 'action-column'],
                        'contentOptions' => ['style' => 'width:50px;'],
                        'header' => 'Actions',
                        'visible' => (Yii::$app->user->identity->role == (User::ROLE_ADMIN || User::ROLE_STAFF)) ? true : false,
                        'template' => '{view}{update}{delete}',
                        'visibleButtons' => [
                            'view' => false,
                            'update' => true,
                            'delete' => false,
                        ],
                        'buttons' => [
                                'view' => function ($url, $model) {
                                    return Html::a('<div class="btn btn-success btn-flat btn-xs"><span class="glyphicon glyphicon-eye-open"></span> View</div>', $url, [
                                                'title' => Yii::t('app', 'amc-view'),
                                    ]);
                                },
                                'update' => function ($url, $model) {
                                    return Html::a('<div class="btn btn-info btn-flat btn-xs"><span class="glyphicon glyphicon-pencil"></span> Update</div>', $url, [
                                                'title' => Yii::t('app', 'amc-update'),
                                    ]);
                                },
                        ],
            ],
        ],
    ]); ?>
    </div>
</div>

</div>
