<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use kartik\select2\Select2;
use common\models\Customers;
/* @var $this yii\web\View */
/* @var $model common\models\Amc */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="amc-form">

    <?php $form = ActiveForm::begin(); ?>
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-12">
                        <?php
                            echo $form->field($model, 'user_id')->widget(Select2::classname(), [
                                'data' => Customers::getAllCustomers(),
                                'options' => ['placeholder' => 'Select A Customer'],
                                'pluginOptions' => [
                                    'allowClear' => true
                                ]
                            ]);
                           


                        ?>
                    </div>
                
                    <div class="col-md-12">
                        <?= $form->field($model, 'expiry')->widget(DatePicker::classname(), ['options' => ['placeholder' => 'Enter order date ...', 'autocomplete' => 'off'], 'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true, 'autoclose' => true,]]) ?>
                    </div>
                </div>
                    <div class="form-group">
                        <?= Html::submitButton('Create Amc', ['class' => 'btn btn-success']) ?>
                    </div>
            </div>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

</div>
