<?php

namespace backend\controllers;

use Yii;
use common\models\User;
use common\models\Staffs;
use common\models\StaffsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * StaffsController implements the CRUD actions for Staffs model.
 */
class StaffsController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function beforeAction($action) {

        Yii::$app->user->setReturnUrl(Yii::$app->request->getUrl());
        if (Yii::$app->user->isGuest ) {
            return $this->redirect(Yii::$app->getUrlManager()->getBaseUrl() . '/login ', 302)->send();
        }
        return true;
    }
    /**
     * Lists all Staffs models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new StaffsSearch();
        $searchModel->role = User::ROLE_STAFF;
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Staffs model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Staffs model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Staffs();
        $tempPass = "gracestaff123@";
        if ($model->load(Yii::$app->request->post())) {
            $model->role = User::ROLE_STAFF;
            $model->added_by = Yii::$app->user->id;
            $model->password_hash = Yii::$app->security->generatePasswordHash($tempPass);
            $model->auth_key = Yii::$app->security->generateRandomString();
            $model->verification_token = Yii::$app->security->generateRandomString() . '_' . time();
            $model->status = User::STATUS_ACTIVE;
            $model->created_at = time();
            
//             stop($model);
            if ($model->validate()) {
                if ($model->save()) {
                    return $this->redirect(['index']);
                } else {
                    stop($model->getErrors());
                }
            } else {
                return $this->render('create', [
                            'model' => $model,
                ]);
//                stop($model->getErrors());
            }
            
             return $this->redirect(['index']);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Staffs model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Staffs model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Staffs model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Staffs the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Staffs::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
