<?php

namespace backend\controllers;

use Yii;
use common\models\Services;
use common\models\ServicesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\components\Helper;
use common\models\Customers;
use common\models\Payments;
/**
 * ServicesController implements the CRUD actions for Services model.
 */
class ServicesController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function beforeAction($action) {

        Yii::$app->user->setReturnUrl(Yii::$app->request->getUrl());
        if (Yii::$app->user->isGuest ) {
            return $this->redirect(Yii::$app->getUrlManager()->getBaseUrl() . '/login ', 302)->send();
        }
        return true;
    }

    /**
     * Lists all Services models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new ServicesSearch();
        $searchModel->status ='Pending';
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $dataProvider->sort = ['defaultOrder' => ['id' => 'DESC']];

        $payments = new Payments();
        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'payments' => $payments, 
        ]);
    }

    /**
     * Displays a single Services model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Services model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Services();

        if ($model->load(Yii::$app->request->post())) {

            $user = Customers::findOne(['id' => $model->user_id]);
            $lastServiceId = Helper::getLastServiceID();
            $model->service_number = ($lastServiceId) ? Yii::$app->params['service_alias'].$lastServiceId : Yii::$app->params['service_alias'] . '0001';
            $model->attended_by = Yii::$app->user->id;
            $model->created_at = date('y-m-d H:i:s');
            $model->created_by =Yii::$app->user->id;
            $model->status = "Pending";
            
            if($user->amc_status == 1)
            {
                $model->service_mode = "Amc";
            }
            
            if(($model->total_amount == $model->amount_paid) ||($model->service_mode == "Free")  || ($user->amc_status == 1) ){
                $model->payment_status = 1;
            }
            else
            {
                $model->payment_status = 0;
            }


            if($model->save())
            {
                if($model->amount_paid > 0)
                {
                    $payment = new Payments();
                    $payment->service_id = $model->id; 	
                    $payment->note = "Advance payment for service";
                    $payment->amount =	$model->amount_paid; 
                    $payment->transaction_date = date('y-m-d');
                    $payment->created_by =	Yii::$app->user->id;
                    $payment->created_at = date('y-m-d H:i:s');
                    $payment->save();
                }

            }else{
                stop($model->getErrors());
            }
            

            return $this->redirect(['index']);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Services model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        
        if ($model->load(Yii::$app->request->post())) {
            $user = Customers::findOne(['id' => $model->user_id]);
            if($user->amc_status == 1)
            {
                $model->service_mode = "Amc";
            }

            if(($model->total_amount == $model->amount_paid) || ($model->service_mode == "Free")  || ($user->amc_status == 1) ){
                $model->payment_status = 1;
            }
            else
            {
                $model->payment_status = 0;
            }

            $model->save();
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Services model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Services model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Services the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Services::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionPayment($id)
    {

        $payments = new Payments();
        $model = $this->findModel($id);
        $paid_amounts = Payments::find()->where(['service_id'=>$id])->sum('amount');
        $pending_amount =$model->total_amount - $paid_amounts;
        if ($payments->load(Yii::$app->request->post())) {
            $payments->service_id = $model->id; 	
            $payments->transaction_date = date('y-m-d');
            $payments->created_by =	Yii::$app->user->id;
            $payments->created_at = date('y-m-d H:i:s');

            
            

            if($payments->save()){
                $model->amount_paid = $model->amount_paid + $payments->amount;
                if($model->total_amount <= ($paid_amounts + $payments->amount)){
                    $model->payment_status = '1';
                }
                $model->save();
                if(!$model->save()){
                    stop($model->getErrors());
                }
            }
            else{
                stop($payment->getErrors());
            }

            // stop($payments);
            // $model->save();
            return $this->redirect(['index']);
        }

        // return $this->render('update', [
        //     'model' => $model,
        // ]);
        return $this->renderAjax('_payment', [
            'payments' => $payments,
            'model'=> $model,
            'pending_amount' => $pending_amount
        ]);
    }



}
