<?php

namespace backend\controllers;

use Yii;
use common\models\Sales;
use common\models\SalesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use kartik\mpdf\Pdf;
use common\models\SalesItems;
use common\models\Products;
use common\components\Helper;
use common\models\Customers;
use common\models\Company;

/**
 * SalesController implements the CRUD actions for Sales model.
 */
class SalesController extends Controller {

    /**
     * {@inheritdoc}
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Sales models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new SalesSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Sales model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id) {
        $invoice = $this->findModel($id);
        return $this->render('view', [
                    'invoice' => $invoice,
                    'itemmodel' => SalesItems::findAll(['invoice_id' => $id]),
                    'customer' => Customers::findOne(['id' => $invoice->user_id]),
                    'company' => Company::findOne(['id' => 1])
        ]);
    }

    /**
     * Creates a new Sales model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new Sales();
        $today = date("Y-m-d");
        $model->invoice_number = Helper::getInvoiceID();
        $model->invoice_date = $today;
        $model->due_date = $today;
        $model->status = "Unpaid";
//        $model->is_taxincluded_price =0;
        if ($model->load(Yii::$app->request->post())) {
//            stop(Yii::$app->request->post());

            if ($model->save()) {
                $totalgst = $totalcgst = $totaligst = $totalsgst = $totalitemprice = $subtotal = $total = 0;
                foreach (Yii::$app->request->post()['SalesItems'] as $key => $salesItems) {
                    $salesItem = new SalesItems();
                    $unit =Helper::getProductUnit($salesItems['product_id']);
                    $salesItem->invoice_id = $model->id;
                    $salesItem->product_id = $salesItems['product_id'];
                    $salesItem->unit = $unit->uom;
                    $salesItem->qty = $salesItems['qty'];
                    $salesItem->mrp = $salesItems['mrp'];

                    $product = Helper::getProductDetails($salesItems['product_id']);
                    $catagory = Helper::getProductCatagoryDetails($product['category']);
                    $salesItem->product_name = $product->product_name;
                    $salesItem->hsn_code = $product->hsn_code;
                    $salesItem->cat_name = $catagory->cat_name;
                    $tax = $product->tax_percent;

                    if (isset($salesItems['is_taxincluded_price']) && $salesItems['is_taxincluded_price'] == 1) {
                        $salesItem->is_taxincluded_price = 1;
                        $included_price = $salesItems['mrp'] / (($tax / 100) + 1);
                        $salesItem->price = round($included_price, 3);
                        $itemsubtotal = round($salesItem->price * $salesItem->qty);
                        $itemtax = round(($itemsubtotal * $tax ) / 100, 0);
                    } else {
                        $salesItem->price = $salesItems['mrp'];
                        $itemsubtotal = $salesItems['mrp'] * $salesItems['qty'];
                        $itemtax = ($itemsubtotal * $tax ) / 100;
                    }

                    $totalprice = $itemsubtotal + $itemtax;
                    $cgst = $igst = $sgst = $itemtax / 2;

                    $totalcgst += $cgst;
                    $totaligst += $igst;
                    $totalsgst += $sgst;
                    $totalgst += $itemtax;
                    $subtotal += $itemsubtotal;
                    $total += $totalprice;

                    $salesItem->gst_percent = $tax;
                    $salesItem->igst = $igst;
                    $salesItem->sgst = $sgst;
                    $salesItem->cgst = $cgst;
                    $salesItem->total_tax = $itemtax;
                    $salesItem->sub_total = $itemsubtotal;
                    $salesItem->total_amout = $totalprice;

                    $salesItem->save();
                }


//                    $model->notes =
//                    $model->private_notes =

                $model->cgst = $totalcgst;
                $model->sgst = $totalsgst;
                $model->igst = $totaligst;
                $model->total_tax = $totalgst;
                $model->sub_total = $subtotal;
                $model->invoice_amount = $total;
                $model->save();
            } else {
                stop($model->getErrors());
            }



return $this->redirect(['index']);
//            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
                    'model' => $model,
                    'salesItems' => (empty($salesItems)) ? [new SalesItems] : $salesItems
        ]);
    }

    /**
     * Updates an existing Sales model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        $salesItems = SalesItems::findAll(['invoice_id' => $model->id]);
        if ($model->load(Yii::$app->request->post())) {

            SalesItems::deleteAll(['invoice_id' => $model->id]);
            $totalgst = $totalcgst = $totaligst = $totalsgst = $totalitemprice = $subtotal = $total = 0;
            foreach (Yii::$app->request->post()['SalesItems'] as $key => $salesItems) {
                $salesItem = new SalesItems();
                $unit =Helper::getProductUnit($salesItems['product_id']);
                $salesItem->invoice_id = $model->id;
                $salesItem->product_id = $salesItems['product_id'];
                $salesItem->unit = $unit->uom;
                $salesItem->qty = $salesItems['qty'];
                $salesItem->mrp = $salesItems['mrp'];


                $product = Helper::getProductDetails($salesItems['product_id']);
                $catagory = Helper::getProductCatagoryDetails($product['category']);
                $salesItem->product_name = $product->product_name;
                $salesItem->hsn_code = $product->hsn_code;
                $salesItem->cat_name = $catagory->cat_name;
                $tax = $product->tax_percent;

                if (isset($salesItems['is_taxincluded_price']) && $salesItems['is_taxincluded_price'] == 1) {
                    $salesItem->is_taxincluded_price = 1;
                    $included_price = $salesItems['mrp'] / (($tax / 100) + 1);
                    $salesItem->price = round($included_price, 3);
                    $itemsubtotal = round($salesItem->price * $salesItem->qty);
                    $itemtax = round(($itemsubtotal * $tax ) / 100, 0);
                } else {
                    $salesItem->price = $salesItems['mrp'];
                    $itemsubtotal = $salesItems['mrp'] * $salesItems['qty'];
                    $itemtax = ($itemsubtotal * $tax ) / 100;
                }

                $totalprice = $itemsubtotal + $itemtax;
                $cgst = $igst = $sgst = $itemtax / 2;

                $totalcgst += $cgst;
                $totaligst += $igst;
                $totalsgst += $sgst;
                $totalgst += $itemtax;
                $subtotal += $itemsubtotal;
                $total += $totalprice;




                $salesItem->gst_percent = $tax;
                $salesItem->igst = $igst;
                $salesItem->sgst = $sgst;
                $salesItem->cgst = $cgst;
                $salesItem->total_tax = $itemtax;
                $salesItem->sub_total = $itemsubtotal;
                $salesItem->total_amout = $totalprice;

                $salesItem->save();
            }
            $model->cgst = $totalcgst;
            $model->sgst = $totalsgst;
            $model->igst = $totaligst;
            $model->total_tax = $totalgst;
            $model->sub_total = $subtotal;
            $model->invoice_amount = $total;
            $model->save();
            return $this->redirect(['index']);
//            return $this->redirect(['view', 'id' => $model->id]);
//            stop(Yii::$app->request->post()['SalesItems']);
        }

        return $this->render('update', [
                    'model' => $model,
                    'salesItems' => (empty($salesItems)) ? [new SalesItems] : $salesItems
        ]);
    }

    /**
     * Deletes an existing Sales model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id) {
        if (($itemsmodel = SalesItems::findAll(['invoice_id' => $id])) !== null) {
            foreach ($itemsmodel as $key => $item) {
                SalesItems::findOne($item->id)->delete();
            }
        }

        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Sales model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Sales the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = Sales::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionListProduct() {
        $id = $_REQUEST['id'];
        if (($productmodel = Products::findOne($id)) !== null) {
            return $productmodel->tax_percent;
        }
    }

    public function actionDownloadInvoice($id) {
        $invoice = $this->findModel($id);
        $uploadPath = \Yii::getAlias('@backend') . '/../uploads/';
        $conent = Yii::$app->controller->renderPartial('/sales/invoice', ['invoice' => $this->findModel($id),
            'itemmodel' => SalesItems::findAll(['invoice_id' => $id]),
            'customer' => Customers::findOne(['id' => $invoice->user_id]),
            'company' => Company::findOne(['id' => 1])]);
        $pdf = new Pdf([
            'mode' => Pdf::MODE_CORE, // leaner size using standard fonts
            // A4 paper format
            'format' => Pdf::FORMAT_A4,
            // portrait orientation
            'orientation' => Pdf::ORIENT_PORTRAIT,
            'destination' => Pdf::DEST_BROWSER,
            'cssFile' => '@backend/web/css/pdfinvoice.css',
            'content' => $conent,
//            'options' => [
//                'title' => 'Privacy Policy - Krajee.com',
//                'subject' => 'Generating PDF files via yii2-mpdf extension has never been easy'
//            ],
//            'methods' => [
//                'SetHeader' => ['Generated By: Krajee Pdf Component||Generated On: ' . date("r")],
//                'SetFooter' => ['|Page {PAGENO}|'],
//            ]
        ]);
//        $tempPath = $uploadPath . $invoice->invoice_number . '.pdf';
//        echo $pdf->output($conent, $tempPath, 'F');
        return $pdf->render();
        
    }

}
