<?php

namespace backend\controllers;

use Yii;
use common\models\Amc;
use common\models\AmcSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\models\Customers;
/**
 * AmcController implements the CRUD actions for Amc model.
 */
class AmcController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function beforeAction($action) {

        Yii::$app->user->setReturnUrl(Yii::$app->request->getUrl());
        if (Yii::$app->user->isGuest ) {
            return $this->redirect(Yii::$app->getUrlManager()->getBaseUrl() . '/login ', 302)->send();
        }
        return true;
    }

    /**
     * Lists all Amc models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new AmcSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Amc model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Amc model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Amc();

        if ($model->load(Yii::$app->request->post())) {
            $amc = Amc::findOne(['user_id'=> $model->user_id]);
            $user = Customers::findOne(['id' => $model->user_id]);

            if($amc){
                $amc->created_by = Yii::$app->user->id;
                $amc->expiry = $model->expiry;
                $amc->created_at = date('y-m-d H:i:s');
                $amc->status = 1;
                $amc->save();
                if($amc->save()){
                    $user->amc_expiry = $model->expiry;
                    $user->amc_status = 1;
                    $user->save();
                }
            }
            else{
                $model->created_by = Yii::$app->user->id;
                $model->created_at = date('y-m-d H:i:s');
                $model->status = 1;
                if($model->save()){
                    $user->amc_expiry = $model->expiry;
                    $user->amc_status = 1;
                    $user->save();
                }
            }
            return $this->redirect(['index']);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Amc model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Amc model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Amc model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Amc the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Amc::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionExpireamc()
    {
        $allamcs = Amc::find()->all();
        date_default_timezone_set("Asia/Calcutta");
        $today = strtotime(date("Y-m-d"));
        foreach($allamcs as $key => $amc){
            stop($amc);
            // $expiry_date = strtotime($data->created_at);
            // if($today > $expiry_date){
            //     $user = Customers::findOne(['id' => $amc->user_id]);
            //     $user->amc_status = 0;
            //     $user->save();
            //     $amc->delete();
            //     stop('1 deleted');
            // }
        }
            // return $this->redirect(['index']);
    }

        
    
}
