<?php
class Officemodel extends Model{
	
	private $branch=array();
	private $office=array();
	 
		
	function Officemodel(){
		parent::Model();
	}
	function isHeadOfficeStaff($staffid)
	{
		$row='';
		$this->db->select('officeid');
		$this->db->where('staffid',$staffid);
		$query=$this->db->get('staff');
		if($query->num_rows()>0)
		{
			$row=$query->row_array();
			$officeid=$row['officeid']; 
		}
		return $officeid;	
	}
	function getOffices()
	{
		$data=array();
		$this->db->select('officeid,name')	;
		$query=	$this->db->get('offices');
		if ($query->num_rows() > 0)
		{
	    	foreach ($query->result_array() as $row)
	    	{					
				$data[$row['officeid']]=$row['name'];		        	
	    	}
			return 	$data;	
		}else
		{
			return $data ;	
		}		
	}
	
	
	function getAllBranches($branchid=0){
		$data = array();
		$this->db->select('officeid,code,shortname,name,office_typeid');
		$this->db->where('office_typeid',1);
		if(!empty($branchid)){
			$this->db->where('officeid',$branchid);
		}
		$this->db->order_by('name');
		$query=$this->db->get('offices');
		if ($query->num_rows() > 0)
			{
		    	foreach ($query->result_array() as $row)
		    	{					
					$data[$row['officeid']]=$row['name'];		        	
		    	}	
			}
			return $data;	
	}
	
	function getAllOfficeTypes($officetypeid=0){
		$data=array();
		$this->db->select('type_of_officeid,code,description,position_level');
		$this->db->from('type_of_offices');
		if(!empty($officetypeid)){
			$this->db->where('type_of_officeid',$officetypeid);
		}
		$this->db->order_by('position_level');
		$query=$this->db->get();
		if ($query->num_rows() > 0)
			{
		    	foreach ($query->result_array() as $row)
		    	{					
					$data[$row['position_level']]=$row['description'];		       
		    	}	
			}
		return $data;
	}
	
	
	function getOfficeTypeIdByPosition($position_level){
		$officetypeid=0;
		$this->db->select('type_of_officeid,position_level');
		$this->db->from('type_of_offices');
		$this->db->where('position_level',$position_level);	
		$query=$this->db->get();
		$row=$query->row_array();
		if(!empty($row)){
		$officetypeid=$row['type_of_officeid'];
		}
		return $officetypeid;
		
	}
	
	function getParentOffice($position_level){
		$data=array();
		$officetypeid=$this->officemodel->getOfficeTypeIdByPosition($position_level+1);
		if(!empty($officetypeid)){
		$this->db->select('officeid,name');
		$this->db->from('offices');
		$this->db->where('office_typeid',$officetypeid);
		$query=$this->db->get();
		if ($query->num_rows() > 0)
			{
		    	foreach ($query->result_array() as $row)
		    	{					
					$data[$row['officeid']]=$row['name'];		        	
		    	}	
			}
		}
		return $data;
	}
		
			
	function setOfficeCode($position_level){
		$this->db->select('type_of_officeid,code');
		$this->db->from('type_of_offices');
		$this->db->where('position_level',$position_level);
		$query=$this->db->get();
		$row=$query->row_array();
		$code=$row['code'];
		$officetypeid=$row['type_of_officeid'];		
		
		//$this->db->select_max('CAST(RIGHT(code,4) AS SIGNED)');
		//$this->db->from('offices');
		//$this->db->where('office_typeid',$officetypeid);
		//$query=$this->db->get();
		
		$query=$this->db->query("SELECT MAX(CAST(RIGHT(code,4) AS SIGNED)) as code 
			from offices where office_typeid=$officetypeid");			
		
		$data=$query->row_array();
		$max=$data['code'];
		if(empty($max)){
			$code=$code."0001";
		}else{
			$max=$data['code']+1;
			$max= sprintf("%04d",$max);
			$code=$code.$max;
		}
		return $code;
	}
	
	function validateOffice($data){
		$error_msg='';
			$this->db->select('shortname');
			$this->db->where('shortname',$data['shortname']);
			if(isset($data['officeid']))
			$this->db->where_not_in('officeid',$data['officeid']);
			$result=$this->db->get('offices');			
			if($result->num_rows()>0){
				$error_msg.="The specified shortname already exist.<br>";
			}
			$this->db->select('name');
			$this->db->where('name',$data['name']);
			if(isset($data['officeid']))
			$this->db->where_not_in('officeid',$data['officeid']);
			$result=$this->db->get('offices');			
			if($result->num_rows()>0){
				$error_msg.="The specified name already exist.<br>";
			}			
			$this->db->select('description');
			$this->db->where('position_level',$data['positionlevel']);
			$query=$this->db->get('type_of_offices');
			$row=$query->row_array();
			$description=$row['description'];
			if($description!='Head Office'){
				if(empty($data['parent_officeid']))
					$error_msg.="The parent office field is required.<br>";
			}
			if(!empty($error_msg)){
				$len=strlen($error_msg);
				$error_msg=substr($error_msg,0,$len-4);
			}
			return $error_msg;
	}
				
	function insertOffice($data){
		$insert_arr=array('shortname'=>$data['shortname'],'name'=>$data['name'],
		'parent_officeid'=>$data['parent_officeid'],'address1'=>$data['address1'],
		'address2'=>$data['address2'],'districtid'=>$data['districtid'],
		'stateid'=>$data['stateid'],'phone1'=>$data['phone1'],
		'phone2'=>$data['phone2'],'fax'=>$data['fax'],
		'emailid1'=>$data['emailid1'],'emailid2'=>$data['emailid2'],
		'date_of_commence'=>!empty($data['date_of_commence'])?
			date('Y-m-d',strtotime($data['date_of_commence'])):NULL,
		'go_live_date'=>!empty($data['go_live_date'])?
			date('Y-m-d',strtotime($data['go_live_date'])):NULL, 
		'status'=>$data['status'],'created_by'=>$data['created_by'],
		'created_on'=>date('Y-m-d',strtotime($data['created_on'])));
		
		$insert_arr['code']=$this->officemodel->setOfficeCode($data['positionlevel']);
		$insert_arr['office_typeid']=$this->officemodel->getOfficeTypeIdByPosition($data['positionlevel']);
		$this->db->insert('offices',$insert_arr);
		return $this->db->insert_id();
	}			
	
	
	function updateOffice($data,$id){
	
		$update_arr=array('shortname'=>$data['shortname'],'name'=>$data['name'],
		'parent_officeid'=>$data['parent_officeid'],'address1'=>$data['address1'],
		'address2'=>$data['address2'],'districtid'=>$data['districtid'],
		'stateid'=>$data['stateid'],'phone1'=>$data['phone1'],
		'phone2'=>$data['phone2'],'fax'=>$data['fax'],
		'emailid1'=>$data['emailid1'],'emailid2'=>$data['emailid2'],
		'date_of_commence'=>!empty($data['date_of_commence'])?
			date('Y-m-d',strtotime($data['date_of_commence'])):NULL,
		'go_live_date'=>!empty($data['go_live_date'])?
			date('Y-m-d',strtotime($data['go_live_date'])):NULL,
		'status'=>$data['status'],'modified_by'=>$data['modified_by'],
		'modified_on'=>date('Y-m-d',strtotime($data['modified_on'])));
		$this->db->where('officeid',$id);
		$this->db->update('offices',$update_arr);
	}
	
	function getOfficeCount($params){
		if (!empty($params))
		{
			if  ($params ["search"] == "true")
			{
				if  ($params["search_str"]==NULL)
				{
					$where="1 = 1";
				}
				else {
					
					$where=$params ["search_str"];
					$this->db->where ('O.'.$where);
				}
			}
		}
		return $this->db->count_all_results('offices O');
	}
	
	function getAllOffices($params = "" ,$start,$limit,$page ="all"){
		$this->db->select('O.officeid,O.code,O.shortname,O.name,O.status,T.description as officetype');
		if (!empty($params))
		{
		if  ($params ["search"] == "true")
		{
		if  ($params["search_str"]==NULL)
		{
		$where="1 = 1";
		}
		else {
		
		$where=$params ["search_str"];
		$this->db->where ('O.'.$where);
		}
		}
		if ($page != "all")
		{
		$this->db->limit ($params ["num_rows"], $params ["num_rows"] *  ($params ["page"] - 
		
		1) );
		}
		$this->db->join('type_of_offices T','O.office_typeid=T.type_of_officeid','left');
		$query=$this->db->get('offices O',$start,$limit);
		}
		else{
			$this->db->join('type_of_offices T','O.office_typeid=T.type_of_officeid','left');
			$query=$this->db->get('offices O',$start,$limit);
		}	
		$data=$query->result_array();
		return $data;
	}
	function getOfficeListById($id){
		$this->db->select('O.officeid,O.code,O.shortname,O.name,O.office_typeid,
		O.parent_officeid,O.address1,O.address2,O.districtid,O.stateid,O.phone1,
		O.phone2,O.fax,O.emailid1,O.emailid2,O.date_of_commence,O.go_live_date,
		O.status,T.description as officetype');
		$this->db->from('offices O');
		$this->db->join('type_of_offices T','O.office_typeid=T.type_of_officeid','left');
		$this->db->where('O.officeid',$id);
		$query=$this->db->get();
		$data=$query->result();
		return $data;
	}
	function deleteOffice($id){
		$this->db->select('parent_officeid');
		$this->db->where('parent_officeid',$id);
		$query=$this->db->get('offices');
		if($query->num_rows()>0){
			return 0;
		}else{
			$this->db->delete('offices',array('officeid'=>$id));
			return 1;
		}
	}
	
	function getOfficeIdofHeadOffice(){
		$data='';
		$this->db->select('officeid');
		$this->db->where('office_typeid',6);
		$query=$this->db->get('offices');
		$row=$query->row_array();
		if(!empty($row)){
			$data=$row['officeid'];	
		}
		return $data;
	}
	function getBranchesById($staffid){
		$office='';
		$branches=array();
		$query=$this->db->query('select o.officeid,o.name,too.position_level
				from staff s inner join offices o
				on s.officeid=o.officeid inner join 
				type_of_offices too on o.office_typeid=too.type_of_officeid
				where staffid='.$staffid );
		foreach($query->result_array() as $row){
		$officeid=$row['officeid'];
		$position_level=$row['position_level'];
		$this->branch[0]='';
		if($position_level==1){
		//$this->branch[0]='';
		$this->branch[$row['officeid']]=$row['name'];
		}
		else{
			$this->getBranchesByOffice($officeid);
		}
		}
		return $this->branch;
}
	function getBranchesByOffice($id){
			$query=$this->db->query('select o.officeid,o.name,o.office_typeid
				from offices o inner join type_of_offices too on o.office_typeid
				=too.type_of_officeid where parent_officeid='.$id.' order by o.name asc' );
			if ($query->num_rows() < 1)
	  		return;
			else{
			//$this->branch[0]='';
			foreach ($query->result_array() as $row){
			$this->branch[0]='';
				if($row['office_typeid']==1){
					$this->branch[$row['officeid']]=$row['name'];	
				}
				else{
				$id=$row['officeid'];
				//$isbranch=$row['office_typeid'];
				$this->getBranchesByOffice($id);	
				}		
			}		
		}
		
	}
	function getOfficesById($staffid){
		$office='';
		$branches=array();
		$query=$this->db->query('select o.officeid,o.name,too.position_level
				from staff s inner join offices o
				on s.officeid=o.officeid inner join 
				type_of_offices too on o.office_typeid=too.type_of_officeid
				where staffid='.$staffid);
		foreach($query->result_array() as $row){
		$officeid=$row['officeid'];
		$position_level=$row['position_level'];	
		$this->branch[0]='';
		$this->branch[$row['officeid']]=$row['name'];
		if($position_level==1){		
		}
		else{
			$this->getOfficesByOffice($officeid);
		}
		}
		return $this->branch;
}
	function getOfficesByOffice($id){
			$query=$this->db->query('select o.officeid,o.name,o.office_typeid
				from offices o inner join type_of_offices too on o.office_typeid
				=too.type_of_officeid where parent_officeid='.$id);
			if ($query->num_rows() < 1)
	  		return;
			else{
			$this->branch[0]='';
			foreach ($query->result_array() as $row){				
				$this->branch[$row['officeid']]=$row['name'];				
				$id=$row['officeid'];				
				$this->getOfficesByOffice($id);							
			}		
		}
		
	}
	
	
	
	
	function getAllBranchesById($staffid,$master_type=""){
		$i=0;
		$office='';		
		$this->branch=array();
		if ($master_type==1)$accname="acccostcategoryid";
		elseif ($master_type==2)$accname="acccostcentreid"; 
		elseif ($master_type==3)$accname="accgroupid"; 
		elseif ($master_type==4)$accname="acccostcentreid"; 				
		$strquery="select 0 as "  . $accname . ", o.officeid,o.code,o.name,
				too.position_level	from staff s inner join offices o
				on s.officeid=o.officeid inner join 
				type_of_offices too on o.office_typeid=too.type_of_officeid
				where staffid=".$staffid . "";
						
		$query=$this->db->query($strquery);
		foreach($query->result_array() as $row){
		$officeid=$row['officeid'];
		$position_level=$row['position_level'];
		if($position_level==1){
		$this->branch[$i][$accname]=$row[$accname];
		$this->branch[$i]['officeid']=$row['officeid'];
		$this->branch[$i]['code']=$row['code'];
		$this->branch[$i]['name']=$row['name'];
		}
		else{
			$this->getAllBranchesByOffice($officeid,$i,$master_type);
		}
		$i=$i+1;
		}
		return $this->branch;
}
	function getAllBranchesByOffice($id,$i,$master_type)
	{
			if ($master_type==1)$accname="acccostcategoryid";
			elseif ($master_type==2)$accname="acccostcentreid"; 
			elseif ($master_type==3)$accname="accgroupid"; 
			elseif ($master_type==4)$accname="acccostcentreid"; 
			$strquery="select "  . $accname . ", o.officeid,o.code,o.name,
				o.office_typeid	from offices o inner join type_of_offices
				too on o.office_typeid =too.type_of_officeid 
				where parent_officeid=" . $id ."";			
				
			$query=$this->db->query($strquery);
			if ($query->num_rows() < 1)
	  		return;
			else{			
			foreach ($query->result_array() as $row){
				if($row['office_typeid']==1){
					$this->branch[$i][$accname]=$row[$accname];
					$this->branch[$i]['officeid']=$row['officeid'];
					$this->branch[$i]['code']=$row['code'];
					$this->branch[$i]['name']=$row['name'];	
				}
				else{
				$officeid=$row['officeid'];				
				getAllBranchesByOffice($officeid,$i,$master_type);
				}	
				$i=$i+1;	
			}		
		}
		
	}
	
}