window.marker = null;

function initialize() {
  var map;
  var latitude = $('#map').attr('data-latitude');
  var longitude = $('#map').attr('data-longitude');
  var mapMarker = $('#map').attr('data-marker');
  var mapMarkerName = $('#map').attr('data-marker-name');
  var nottingham = new google.maps.LatLng(latitude, longitude);
  var style = [
  	{elementType: 'geometry', stylers: [{color: '#242f3e'}]},
	{elementType: 'labels.text.stroke', stylers: [{color: '#242f3e'}]},
	{elementType: 'labels.text.fill', stylers: [{color: '#746855'}]},
	{
	  featureType: 'administrative.locality',
	  elementType: 'labels.text.fill',
	  stylers: [{color: '#d59563'}]
	},
	{
	  featureType: 'poi',
	  elementType: 'labels.text.fill',
	  stylers: [{color: '#d59563'}]
	},
	{
	  featureType: 'poi.park',
	  elementType: 'geometry',
	  stylers: [{color: '#263c3f'}]
	},
	{
	  featureType: 'poi.park',
	  elementType: 'labels.text.fill',
	  stylers: [{color: '#6b9a76'}]
	},
	{
	  featureType: 'road',
	  elementType: 'geometry',
	  stylers: [{color: '#38414e'}]
	},
	{
	  featureType: 'road',
	  elementType: 'geometry.stroke',
	  stylers: [{color: '#212a37'}]
	},
	{
	  featureType: 'road',
	  elementType: 'labels.text.fill',
	  stylers: [{color: '#9ca5b3'}]
	},
	{
	  featureType: 'road.highway',
	  elementType: 'geometry',
	  stylers: [{color: '#746855'}]
	},
	{
	  featureType: 'road.highway',
	  elementType: 'geometry.stroke',
	  stylers: [{color: '#1f2835'}]
	},
	{
	  featureType: 'road.highway',
	  elementType: 'labels.text.fill',
	  stylers: [{color: '#f3d19c'}]
	},
	{
	  featureType: 'transit',
	  elementType: 'geometry',
	  stylers: [{color: '#2f3948'}]
	},
	{
	  featureType: 'transit.station',
	  elementType: 'labels.text.fill',
	  stylers: [{color: '#d59563'}]
	},
	{
	  featureType: 'water',
	  elementType: 'geometry',
	  stylers: [{color: '#17263c'}]
	},
	{
	  featureType: 'water',
	  elementType: 'labels.text.fill',
	  stylers: [{color: '#515c6d'}]
	},
	{
	  featureType: 'water',
	  elementType: 'labels.text.stroke',
	  stylers: [{color: '#17263c'}]
	}
  ];
  var mapOptions = {
    center: nottingham,
    mapTypeId: google.maps.MapTypeId.ROADMAP,
    backgroundColor: "#000",
    zoom: 10,
    panControl: !1,
    zoomControl: !0,
    mapTypeControl: !1,
    scaleControl: !1,
    streetViewControl: !1,
    overviewMapControl: !1,
    zoomControlOptions: {
      style: google.maps.ZoomControlStyle.LARGE
    }
  }
  map = new google.maps.Map(document.getElementById('map'), mapOptions);
  var mapType = new google.maps.StyledMapType(style, {
    name: "Grayscale"
  });
  map.mapTypes.set('grey', mapType);
  map.setMapTypeId('grey');
  var marker_image = mapMarker;
  var pinIcon = new google.maps.MarkerImage(marker_image, null, null, null, new google.maps.Size(46, 40));
  marker = new google.maps.Marker({
    position: nottingham,
    map: map,
    icon: pinIcon,
    title: mapMarkerName
  })
}
var map = document.getElementById('map');
if (map != null) {
  google.maps.event.addDomListener(window, 'load', initialize)
}