<?php

namespace common\models;

use Yii;
use yii\db\Query;


/**
 * This is the model class for table "transactions".
 *
 * @property integer $id
 * @property integer $package_id
 * @property string $date
 * @property string $transaction_id
 * @property string $transaction_status
 * @property integer $office_id
 * @property string $payment_mode
 */
class Transactions extends \yii\db\ActiveRecord {

    /**
     * @inheritdoc
     */
    public static function tableName() {
        return 'transactions';
    }

    /**
     * @inheritdoc
     */
    public function rules() {
        return [
            [['package_id', 'date', 'office_id', 'payment_mode','request_id','item'], 'required'],
            [['package_id', 'office_id'], 'integer'],
            [['date'], 'safe'],
            [['payment_mode','request_id'], 'string'],
            [['transaction_id', 'transaction_status'], 'string', 'max' => 100],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels() {
        return [
            'id' => 'ID',
            'package_id' => 'Package ID',
            'date' => 'Date',
            'transaction_id' => 'Transaction ID',
            'transaction_status' => 'Transaction Status',
            'office_id' => 'Office ID',
            'payment_mode' => 'Payment Mode',
            'request_id'=>'Payment Request Id'
        ];
    }

    public static function getPurchaseHistory($id) {
        $query = new Query;
        $query->select([
                    'transactions.*',
                    'sms_plans.plan_name',
                    'sms_plans.sms_count',
                    'sms_plans.price']
                )
                ->from('transactions')
                ->join('LEFT JOIN', 'sms_plans', 'transactions.package_id =sms_plans.id')
                ->where('transactions.office_id = ' . $id)
                ->orderBy('transactions.id');

        $command = $query->createCommand();
//        stop($command->getSql());
        $data = $command->queryAll();
        return $data;
    }


}
