<?php

namespace common\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Cases;

/**
 * CasesSearch represents the model behind the search form about `common\models\Cases`.
 */
class CasesSearch extends Cases {

    public $clientName;

    /**
     * @inheritdoc
     */
    public function rules() {
        return [
            [['id', 'created_by', 'status', 'office_id', 'client_type', 'client_name', 'opponent_type','list'], 'integer'],
            [['case_number', 'case_details', 'created_on', 'appeared_by', 'next_appearing_date', 'clientName','opponent_name','office_id'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
       
        $this->office_id = Yii::$app->user->identity->office_id;
        
        $query = Cases::find();

        // add conditions that should always apply here
//        $query->joinWith(['clientName']);
        $dataProvider = new ActiveDataProvider([
            'query' => $query, 'sort' => ['defaultOrder' => ['id' => SORT_DESC]],
        ]);
        $dataProvider->sort->attributes['clientName'] = [
            // The tables are the ones our relation are configured to
            // in my case they are prefixed with "tbl_"
            'asc' => ['clients.name' => SORT_ASC],
            'desc' => ['clients.name' => SORT_DESC],
        ];
//        stop($params);
        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'created_on' => $this->created_on,
            'created_by' => $this->created_by,
//            'next_appearing_date' => $this->next_appearing_date,
            'cases.status' => $this->status,
            'cases.office_id' => $this->office_id,
            'client_type' => $this->client_type,
            'client_name' => $this->client_name,
            'opponent_type' => $this->opponent_type,
            'list'=>  $this->list,
        ]);
        
        $query->andFilterWhere(['like', 'clients.name', $this->clientName]);
        $query->andFilterWhere(['like', 'case_number', $this->case_number])
                ->andFilterWhere(['like', 'case_details', $this->case_details])
                ->andFilterWhere(['like', 'appeared_by', $this->appeared_by])
                ->andFilterWhere(['like', 'opponent_name', $this->opponent_name]);
        $startdateRange = explode(' ', $this->next_appearing_date);
        if ($startdateRange[0] != '') {
            $query->andFilterWhere(['between', 'next_appearing_date', $startdateRange[0], $startdateRange[2]]);
//            $query->orFilterWhere(['like', 'next_appearing_date', date('Y-m-d', strtotime($startdateRange[0]))]); //for current date search
        }

        return $dataProvider;
    }

}
