<?php

namespace backend\controllers;

use Yii;
use common\models\SmsPlans;
use common\models\Transactions;
use common\components\Helper;
use common\models\SmsPlansSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\models\Offices;

/**
 * SmsPlansController implements the CRUD actions for SmsPlans model.
 */
class SmsPlansController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }
    /**
     * if not logged in redirect to login page
     */
    public function beforeAction() {

        Yii::$app->user->setReturnUrl(Yii::$app->request->getUrl());
        if (Yii::$app->user->isGuest && $this->id != "site") {
            return $this->redirect(Yii::$app->getUrlManager()->getBaseUrl() . '/login ', 302)->send();
        }
        return true;
    }
    

    /**
     * Lists all SmsPlans models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new SmsPlansSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single SmsPlans model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new SmsPlans model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $model = new SmsPlans();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                        'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing SmsPlans model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                        'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing SmsPlans model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id) {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the SmsPlans model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return SmsPlans the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = SmsPlans::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    public function actionPurchase($id) {
        $officeDetails = Offices::findOne(Yii::$app->user->identity->office_id);

        $planDetails = $this->findModel($id);
        $paymentStatus = Helper::payment($planDetails, $officeDetails);
        if ($paymentStatus) {
            $purchaseHistory = new Transactions();
            $purchaseHistory->office_id = Yii::$app->user->identity->office_id;
            $purchaseHistory->date = date('Y-m-d');
            $purchaseHistory->request_id = $paymentStatus['id'];
            $purchaseHistory->payment_mode = 'Online';
            $purchaseHistory->package_id = $id;
            $purchaseHistory->transaction_status = 'Failed';
            $purchaseHistory->item = 'sms';
            $purchaseHistory->save();
            $this->redirect($paymentStatus['longurl']);
        } else {
            Yii::$app->session->setFlash('danger', 'Unable to process payment! Please try again');
            return $this->redirect(['transactions/index']);
        }
    }

}
