<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "offices".
 *
 * @property integer $id
 * @property string $name
 * @property string $address
 * @property string $district
 * @property string $state
 */
class Offices extends \yii\db\ActiveRecord {

    /**
     * @inheritdoc
     */
    public static function tableName() {
        return 'offices';
    }

    /**
     * @inheritdoc
     */
    public function rules() {
        return [
            [['address'], 'string'],
            [['name'], 'string', 'max' => 255],
            [['sms_sender_id'], 'string', 'max' => 6],
            [['remaining_sms', 'mpin','plan'], 'integer'],
            [['district', 'state'], 'string', 'max' => 100],
            [['url'], 'url', 'defaultScheme' => 'http'],
            [['plan_expiry'], 'safe'],
             [['name','address','state','district'], 'required', 'on' => 'office-details']
        ];
    }
    public function scenarios()
{
    $scenarios = parent::scenarios();
    $scenarios['office-details'] = ['name','address','state','district'];

    return $scenarios;
}

    /**
     * @inheritdoc
     */
    public function attributeLabels() {
        return [
            'id' => 'ID',
            'name' => 'Office Name',
            'address' => 'Address',
            'district' => 'District',
            'state' => 'State',
        ];
    }

}
