<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\models\OpponentType;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;
use kartik\depdrop\DepDrop;
use kartik\date\DatePicker;

/* @var $this yii\web\View */
/* @var $model common\models\Opponents */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="opponents-form">

    <?php $form = ActiveForm::begin(); ?>
    <?php
    if ($model->isNewRecord) {
        $opponentType = OpponentType::find()->where(['status' => 1, 'office_id' => Yii::$app->user->identity->office_id])->asArray()->all();
    } else {
        $opponentType = OpponentType::find()->where(['office_id' => Yii::$app->user->identity->office_id])->asArray()->all();
    }
    $opponentType = ArrayHelper::map($opponentType, 'id', 'type');
    echo $form->field($model, 'opponent_type')->widget(Select2::classname(), [
        'data' => $opponentType,
        'options' => ['placeholder' => 'Select Opponent ...'],
        'pluginOptions' => [
            'allowClear' => true
        ]
    ]);
    ?>

    <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>


    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
