<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "user".
 *
 * @property integer $id
 * @property string $username
 * @property string $first_name
 * @property string $last_name
 * @property string $auth_key
 * @property string $password_hash
 * @property string $password_reset_token
 * @property string $email
 * @property string $phone
 * @property integer $role
 * @property string $created_on
 * @property string $logged_on
 * @property integer $status
 * @property integer $office_id
 */
class User extends \yii\db\ActiveRecord {

    const STATUS_DELETED = 0;
    const STATUS_ACTIVE = 1;
    const STATUS_DEACTIVE = 2;
    const ROLE_SUPER_ADMIN = 10;
    const ROLE_ADMIN = 20;
    const ROLE_ADVOCATE = 30;
    const ROLE_STAFF = 40;

    public $password;
    public $password_repeat;

    /**
     * @inheritdoc
     */
    public static function tableName() {
        return 'user';
    }

    /**
     * @inheritdoc
     */
    public function rules() {
        return [
            [['first_name', 'last_name', 'password_hash', 'email', 'role'], 'required','except' => 'create-user'],
            [['role', 'status', 'office_id'], 'integer'],
            [['created_on', 'logged_on', 'password_repeat'], 'safe'],
            [['username', 'first_name', 'last_name', 'password_hash', 'password_reset_token', 'email'], 'string', 'max' => 255],
            [['auth_key'], 'string', 'max' => 32],
            [['phone'], 'string', 'max' => 15],
            [['username'], 'unique'],
            [['email'], 'unique'],
            [['password_reset_token'], 'unique'],
            ['password', 'required'],
            ['password', 'string', 'min' => 6],
            ['password_repeat', 'required'],
            ['password_repeat', 'string', 'min' => 6],
            ['password_repeat', 'compare', 'compareAttribute' => 'password', 'message' => "Passwords don't match"],
            [['first_name', 'last_name', 'phone'], 'required', 'on' => 'create-user'],
            [['email','phone'], 'unique', 'on' => 'create-user'],
//            ['password', 'compare', 'compareAttribute' => 'password_confirm', 'message' => "Passwords don't match"],
        ];
    }

    public function scenarios() {
        $scenarios = parent::scenarios();
        $scenarios['create-user'] = ['first_name', 'last_name', 'phone','email'];

        return $scenarios;
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels() {
        return [
            'id' => 'ID',
            'username' => 'Username',
            'first_name' => 'First Name',
            'last_name' => 'Last Name',
            'auth_key' => 'Auth Key',
            'password_hash' => 'Password',
            'password_reset_token' => 'Password Reset Token',
            'email' => 'Email',
            'phone' => 'Phone',
            'role' => 'Role',
            'created_on' => 'Created On',
            'logged_on' => 'Logged On',
            'status' => 'Status',
            'office_id' => 'Office ID',
        ];
    }

    /**
     * Generates "remember me" authentication key
     */
    public function generateAuthKey() {
        $this->auth_key = Yii::$app->security->generateRandomString();
    }

    /**
     * Generates password hash from password and sets it to the model
     *
     * @param string $password
     */
    public function setPassword($password) {
        $this->password_hash = Yii::$app->security->generatePasswordHash($password);
    }

}
