<?php

namespace backend\controllers;

use Yii;
use app\models\User;
use common\models\Offices;
use app\models\UserSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\components\AccessRule;
use yii\filters\AccessControl;
use \common\components\Helper;

/**
 * UserController implements the CRUD actions for User model.
 */
class UserController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                // We will override the default rule config with the new AccessRule class
                'ruleConfig' => [
                    'class' => AccessRule::className(),
                ],
                'only' => ['create', 'update', 'delete'],
                'rules' => [
                    [
                        'actions' => ['create'],
                        'allow' => true,
                        // Allow users, moderators and admins to create
                        'roles' => [
                            User::ROLE_SUPER_ADMIN
                        ],
                    ],
                    [
                        'actions' => ['update'],
                        'allow' => true,
                        // Allow moderators and admins to update
                        'roles' => [
                            User::ROLE_SUPER_ADMIN
                        ],
                    ],
                    [
                        'actions' => ['delete'],
                        'allow' => true,
                        // Allow admins to delete
                        'roles' => [
                            User::ROLE_SUPER_ADMIN
                        ],
                    ],
                ],
            ],
        ];
    }

    /**
     * if not logged in redirect to login page
     */
    public function beforeAction($action) {

        Yii::$app->user->setReturnUrl(Yii::$app->request->getUrl());
        if (Yii::$app->user->isGuest && $this->id != "site") {
            return $this->redirect(Yii::$app->getUrlManager()->getBaseUrl() . '/login ', 302)->send();
        }
        return true;
    }

    /**
     * Lists all User models.
     * @return mixed
     */
    public function actionIndex() {
        $searchModel = new UserSearch();
        $searchModel->role = User::ROLE_ADMIN;
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        $resetButton = (count(Yii::$app->request->queryParams) > 0) ? false : true;

        return $this->render('index', [
                    'searchModel' => $searchModel,
                    'dataProvider' => $dataProvider,
                    'resetButton' => $resetButton,
        ]);
    }

    /**
     * Displays a single User model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id) {
        return $this->render('view', [
                    'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new User model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate() {
        $tempPass = rand(1000, 9999);
        $model = new User ();
        $model->scenario = 'create-user';
        $model1 = new Offices();
        $model->role = User::ROLE_ADMIN;
        $model->password = $tempPass;
        $model->password_hash = $tempPass;
        $model->password_repeat = $tempPass;
//        stop($model);
//        stop(Yii::$app->request->queryParams['type']);
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            $data = Yii::$app->request->post();
            $model->email = $data['User']['email'];
            $model->username = $data['User']['email'];
            $model->created_on = date('Y-m-d H:i:s');
            $model->status = User::STATUS_ACTIVE;

            $model->setPassword($tempPass);
            $model->generateAuthKey();

            if ($model->save()) {

                $model1->name = '';
                $model1->remaining_sms = Yii::$app->params['free_sms_count'];
                if ($model1->save()) {
                    $model->office_id = $model1->id;
                    $model->save();
                    $to = $model->email;
                    $subject = '[LAW]- Login Credentials';
                    $templateData['name'] = $model->first_name . ' ' . $model->last_name;
                    $templateData['email'] = $model->email;
                    $templateData['password'] = $tempPass;
                    $file = 'newCustomer';
                    $message = Yii::$app->params['signup_message'];
                    $params = array('temp' => $tempPass);
                    Helper::sendPublicMessage($message, $params, $model->phone);

//                    Helper::sendMail($to, $subject, $templateData, $file);
                    Yii::$app->session->setFlash('success', 'User added successfully!');
                } else {
                    Yii::$app->session->setFlash('error', 'Unable to create user, Please try again');
                }
            } else {
                Yii::$app->session->setFlash('error', 'Unable to create user, Please try again');
            }
//            stop($tempPass);
            return $this->redirect(['index']);
        } else {
            return $this->render('create', [
                        'model' => $model,
                        'params' => Yii::$app->request->queryParams
            ]);
        }
    }

    /**
     * Updates an existing User model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id) {
        $model = $this->findModel($id);
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            $data = Yii::$app->request->post();
            $model->email = $data['User']['email'];
            $model->username = $data['User']['email'];
//            stop($data['User']['password']);
            if ($data['User']['password'] != '$#abcd123&') {
                $model->setPassword($data['User']['password']);
                $model->generateAuthKey();
            }
            if ($model->save()) {
                Yii::$app->session->setFlash('success', 'User updated successfully!');
            } else {
                Yii::$app->session->setFlash('error', 'Unable to update user details, Please try again');
            }
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                        'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing User model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionProfile() {
        $model = $this->findModel(Yii::$app->user->identity->id);
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            $data = Yii::$app->request->post();
            $model->email = $data['User']['email'];
            $model->username = $data['User']['email'];
            if ($data['User']['password'] != '$#abcd123&') {
                $model->setPassword($data['User']['password']);
                $model->generateAuthKey();
            }
            if ($model->save()) {

                Yii::$app->session->setFlash('success', 'User updated successfully!');
            } else {
                Yii::$app->session->setFlash('error', 'Unable to update user details, Please try again');
            }
            return $this->redirect(['profile']);
        } else {
            return $this->render('update', [
                        'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing User model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id) {
        $model = $this->findModel($id);
        $model->scenario = 'create-user';
        $status = User::STATUS_DELETED;
        $model->status = $status;
        $model->save();

        Yii::$app->session->setFlash('success', 'User deleted successfully!');
        return $this->redirect(['index']);
    }

    /**
     * Finds the User model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return User the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id) {
        if (($model = User::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    public function actionStatusupdate($id) {

        $model = $this->findModel($id);
        $status = ($model->status == 1) ? User::STATUS_DEACTIVE : User::STATUS_ACTIVE;
        $model->status = $status;
        $model->save();
        Yii::$app->session->setFlash('success', 'Status changed successfully!');
        return $this->redirect(Yii::$app->request->referrer);
    }

}
