/* @license
dashboard.js v0.1.0
Copyright 2017 Martin K A  All rights reserved.
Licensed under the BSD-2-Clause License.
*/
$(document).ready(function () {
    
    $.getJSON('totalcases', function (data) {
        Morris.Donut({
            element: 'donut-chart'
            , data: data
            , colors: ["#373651", "#E65A26", "#00765a"]
            , resize: true
        });
    });
    
    
    $.getJSON('hearings-line-chart', function (data) {
        Morris.Line({
            element: 'line-chart2'
            , data: data
            , xkey: 'date'
            , ykeys: ['hearing']
            , labels: ['Hearing']
            , hideHover: 'auto'
            , numLines: 5
            , yLabelFormat: function (y) {
                return y != Math.round(y) ? '' : y;
            }
            , resize: true
            , lineColors: ['gray']
        });
    });
    
    
    $.getJSON('hearings-bar-chart', function (data) {
        Morris.Bar({
            element: 'bar-chart'
            , data: data
            , resize: true
            , barColors: ["gray"]
            , xkey: 'y'
            , numLines: 5
            , yLabelFormat: function (y) {
                return y != Math.round(y) ? '' : y;
            }
            , ykeys: ['a']
            , labels: ['Hearing']
            , hideHover: 'auto'
        });
    });
    
     function labelFormatter(label, series) {
        return '<div style="font-size:13px; text-align:center; padding:2px; color: #fff; font-weight: 600;">' + label + "<br>" + Math.round(series.percent) + "%</div>";
    }
    
    $('#calendar').fullCalendar({
        header: {
            left: 'prev,next today'
            , center: 'title'
            , right: ''
        }
        , buttonText: {
            month: 'month'
            , week: 'week'
        }
        , events: {
            url: 'hearings-calender'
        }
    });
    
});