<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use common\models\User;

/* @var $this yii\web\View */
/* @var $searchModel app\models\UserSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Staffs';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="user-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]);  ?>

    <p>
        <?=
        Html::a('Create Staff', ['create'], ['class' => 'btn btn-success']);
        if (!$resetButton) {
            $url = (isset($_GET['id'])) ? '/staff?id=' . $_GET['id'] : '/staff'
            ?>
            <?php echo Html::a('Reset Filter', [$url], ['class' => 'btn btn-info']); ?><br>
        <?php } ?>
    </p>
    <?php Pjax::begin(); ?>    <?=
    GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
//            'id',
//            'username',
            'first_name',
            'last_name',
//            'auth_key',
            // 'password_hash',
            // 'password_reset_token',
            'email:email',
            'phone',
            // 'role',
            // 'created_on',
            // 'logged_on',
            // 'status',
            // 'office_id',
            [
                'attribute' => 'status',
                'visible' => (Yii::$app->user->identity->role == User::ROLE_ADMIN),
                'format' => 'raw',
                'value' => function($data) {
                    return $data->status == 2 ? Html::a('Inactive', 'user/statusupdate/' . $data->id, ['class' => 'btn btn-xs btn-warning']) : Html::a('Active', 'user/statusupdate/' . $data->id, ['class' => 'btn btn-xs btn-success']);
                },
                        'filter' => Html::activeDropDownList($searchModel, 'status', ["2" => "Active", "1" => "Inactive"], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    [
                        'attribute' => 'role',
                        'format' => 'raw',
                        'value' => function($data) {
                            if ($data->role == User::ROLE_ADVOCATE) {
                                $role = 'Advocate';
                            } else if ($data->role == User::ROLE_STAFF) {
                                $role = 'Staff';
                            } else {
                                $role = 'Admin';
                            }

                            return $role;
                        },
                        'filter' => Html::activeDropDownList($searchModel, 'role', [User::ROLE_ADVOCATE => 'Advocate', User::ROLE_STAFF => 'Staff'], ['class' => 'form-control', 'prompt' => 'Select All']),
                    ],
                    [
                        'class' => 'yii\grid\ActionColumn',
                        'contentOptions' => ['style' => 'width:50px;'],
                        'header' => 'Actions',
                        'visible' => (Yii::$app->user->identity->role == User::ROLE_ADMIN),
                        'template' => '{update}{delete}',
                    ],
                ],
            ]);
            ?>
            <?php Pjax::end(); ?></div>
