<?php

use yii\helpers\Html;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model common\models\SmsPurchaseHistory */

$this->title = 'Purchase History';
$this->params['breadcrumbs'][] = $this->title;
?>
    <div class="sms-purchase-history-create">
        <div class="col-md-12">
            <div class="row">
                <div class="col-md-3">
                    <div class="box box-success box-solid">
                        <div class="box-header with-border">
                            <h3 class="box-title">Remaining Sms</h3>
                            <!-- /.box-tools -->
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <?php echo $officeDetails->remaining_sms; ?>
                        </div>
                        <!-- /.box-body -->
                    </div>
                    <!-- /.box -->
                </div>
                <div class="col-md-3">
                    <div class="box box-success box-solid">
                        <div class="box-header with-border">
                            <h3 class="box-title">Sms Sender ID</h3>
                            <!-- /.box-tools -->
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <?php echo ($officeDetails->sms_sender_id)?$officeDetails->sms_sender_id:'Nill'; ?>
                        </div>
                        <!-- /.box-body -->
                    </div>
                    <!-- /.box -->
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="row">
                <div class="col-md-6">
                    <div class="box box-default">
                        <div class="box-header with-border"> <i class="fa fa-warning"></i>
                            <h3 class="box-title">Sms Plans</h3> </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th> Plan Name</th>
                                        <th> Sms Count</th>
                                        <th> Amount</th>
                                        <th> Buy SMS</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
            foreach ($smsPlans as $key => $value) {
                ?>
                                        <tr data-key="<?php echo $key; ?>">
                                            <td>
                                                <?php echo $key + 1; ?>
                                            </td>
                                            <td>
                                                <?php echo $value['plan_name']; ?>
                                            </td>
                                            <td>
                                                <?php echo $value['sms_count']; ?>
                                            </td>
                                            <td>
                                                <?php echo $value['price']; ?>
                                            </td>
                                            <td><a href="<?php echo Url::to(['sms-plans/purchase', 'id' => $value['id']]); ?>" class="btn btn-sm btn-primary">Buy Now</a></td>
                                        </tr>
                                        <?php } ?>
                                </tbody>
                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                    <!-- /.box -->
                </div>
                <div class="col-md-6">
                    <div class="box box-default">
                        <div class="box-header with-border"> <i class="fa fa-warning"></i>
                            <h3 class="box-title">Purchase History</h3> </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <div class="table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th> Plan Name</th>
                                        <th> Purchase Date</th>
                                        <th> Sms Count</th>
                                        <th> Amount</th>
                                        <th> Transaction ID</th>
                                        <th> Transaction Mode</th>
                                        <th> Transaction Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
            if ($purchaseHistory) {
                foreach ($purchaseHistory as $keys => $values) {
                    ?>
                                        <tr data-key="<?php echo $keys ?>">
                                            <td>
                                                <?php echo $keys + 1; ?>
                                            </td>
                                            <td>
                                                <?php echo $values['plan_name']; ?>
                                            </td>
                                            <td>
                                                <?php echo $values['date']; ?>
                                            </td>
                                            <td>
                                                <?php echo $values['sms_count']; ?>
                                            </td>
                                            <td>
                                                <?php echo $values['price']; ?>
                                            </td>
                                            <td>
                                                <?php echo $values['transaction_id']; ?>
                                            </td>
                                            <td>
                                                <?php echo $values['payment_mode']; ?>
                                            </td>
                                            <td>
                                                <?php echo $values['transaction_status']; ?>
                                            </td>
                                        </tr>
                                        <?php
                }
            } else {
                ?>
                                            <tr>
                                                <td colspan="7">
                                                    <div class="empty">No results found.</div>
                                                </td>
                                            </tr>
                                            <?php } ?>
                                </tbody>
                            </table>
                            </div>
                        </div>
                        <!-- /.box-body -->
<!--
                        <div class="box-footer clearfix">
                            <ul class="pagination pagination-sm no-margin pull-right">
                                <li><a href="#">«</a></li>
                                <li><a href="#">1</a></li>
                                <li><a href="#">2</a></li>
                                <li><a href="#">3</a></li>
                                <li><a href="#">»</a></li>
                            </ul>
                        </div>
-->
                    </div>
                    <!-- /.box -->
                </div>
            </div>
        </div>
    </div>