<?php

$params = array_merge(
        require(__DIR__ . '/../../common/config/params.php'), require(__DIR__ . '/../../common/config/params-local.php'), require(__DIR__ . '/params.php'), require(__DIR__ . '/params-local.php')
);

return [
    'id' => 'app-backend',
    'name' => 'Advocate ',
    'basePath' => dirname(__DIR__),
    'controllerNamespace' => 'backend\controllers',
    'bootstrap' => ['log'],
    'modules' => [],
    'homeUrl' => '/lawnew/manage',
    'components' => [
        
        'request' => [
            'csrfParam' => '_csrf-backend',
//            'baseUrl' => '/demo/law',
            'baseUrl' => '/lawnew/manage',
        ],
        'user' => [
            'identityClass' => 'common\models\User',
            'enableAutoLogin' => true,
            'identityCookie' => ['name' => '_identity-backend', 'httpOnly' => true],
        ],
        'session' => [
            // this is the name of the session cookie used for login on the backend
            'name' => 'advanced-backend',
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
                'user/F<type:\w+>' => 'user/index',
                'user/type/<type:\w+>' => 'user/index',
                'user/create/<type:\w+>' => 'user/create',
                'user/<type:\w+>/view/<id:\w+>' => 'user/view',
                'user/<type:\w+>/update/<id:\w+>' => 'user/update',
                'dashboard' => 'dashboard/index',
            ],
        ],
    ],
    'timeZone' => 'Asia/Kolkata',
    'defaultRoute' => 'dashboard/',
    'params' => $params,
    'defaultRoute' => 'site/login'
];
