<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "plans".
 *
 * @property integer $id
 * @property string $name
 * @property integer $m_price
 * @property integer $y_price
 * @property integer $trail_period
 * @property string $other_features
 * @property integer $sms_count
 * @property integer $staff_module
 * @property integer $status
 */
class Plans extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'plans';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'm_price', 'y_price', 'trail_period', 'other_features', 'sms_count', 'status'], 'required'],
            [['m_price', 'y_price', 'trail_period', 'sms_count', 'status'], 'integer'],
            [['other_features'], 'string'],
            [['name'], 'string', 'max' => 200],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'm_price' => 'M Price',
            'y_price' => 'Y Price',
            'trail_period' => 'Trail Period',
            'other_features' => 'Other Features',
            'sms_count' => 'Sms Count',
            'staff_module' => 'Staff Module',
            'status' => 'Status',
        ];
    }
}
