/* @license
dashboard.js v0.1.0
Copyright 2017 Martin K A  All rights reserved.
Licensed under the BSD-2-Clause License.
*/
$(document).ready(function () {
    
    $.getJSON('totalcases', function (data) {
        Morris.Donut({
            element: 'donut-chart'
            , data: data
            , colors: ["#c8c2f3" , "#7f73d6"]
            , resize: true
        });
    });
    
    
    $.getJSON('hearings-line-chart', function (data) {
        Morris.Line({
            element: 'line-chart2'
            , data: data
            , xkey: 'date'
            , ykeys: ['hearing']
            , labels: ['Hearing']
            , hideHover: 'auto'
            , numLines: 5
            , yLabelFormat: function (y) {
                return y != Math.round(y) ? '' : y;
            }
            , resize: true
            , lineColors: ['#b477de']
        });
    });
    
    
    $.getJSON('hearings-bar-chart', function (data) {
        Morris.Bar({
            element: 'bar-chart'
            , data: data
            , resize: true
            , barColors: ["#47bbf6"]
            , xkey: 'y'
            , numLines: 5
            , yLabelFormat: function (y) {
                return y != Math.round(y) ? '' : y;
            }
            , ykeys: ['a']
            , labels: ['Hearing']
            , hideHover: 'auto'
        });
    });
    
     function labelFormatter(label, series) {
        return '<div style="font-size:13px; text-align:center; padding:2px; color: #fff; font-weight: 600;">' + label + "<br>" + Math.round(series.percent) + "%</div>";
    }
    
    $('#calendar').fullCalendar({
        header: {
            left: 'prev,next today'
            , center: 'title'
            , right: ''
        }
        , buttonText: {
            month: 'month'
            , week: 'week'
        }
        , events: {
            url: 'hearings-calender'
        }
    });
    
});