<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\Hearings */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Hearings', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="hearings-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'case_id',
            'hearing_date',
            'amount_paid',
            'description:ntext',
            'office_id',
        ],
    ]) ?>

</div>
