<?php
namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Storage;

class ProcessImageUpload implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $filePath;
    public $destination;

    /**
     * Create a new job instance.
     *
     * @param string $filePath
     * @param string $destination
     */
    public function __construct(string $filePath, string $destination)
    {
        $this->filePath = $filePath;
        $this->destination = $destination;
    }

    /**
     * Execute the job.
     */
    public function handle()
    {
        // Open the file and move it to the destination
        $file = Storage::disk('local')->get($this->filePath);
        $fileName = basename($this->filePath);
        \Log::info("Image ------------------------: " . $fileName);

        // Store the file in the public storage
        $publicPath = Storage::disk('public')->put("{$this->destination}/{$fileName}", $file);

        // Delete the temporary file
        Storage::disk('local')->delete($this->filePath);

        // Optional: Log the uploaded file path
        \Log::info("Image uploaded successfully to: " . $publicPath);
    }
}

