<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package abe
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, user-scalable=no">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <title>Abe</title>
		<?php wp_head(); ?>
    </head>
    <body <?php body_class(); ?>>
<?php wp_body_open(); ?>
        <div class="main container">
           <div class="scrolling-quote">
                <a href="<?php echo esc_url( get_permalink(26) ); ?>" aria-label="Quote"></a>
            </div>
            <header>
                <div class="content m-auto">
                    <div class="row">
                        <div class="col-md-3 pull-left">
                            <div class="logo">
                                <a href="<?php echo home_url(); ?>">
                                <?php if (has_custom_logo()) {
    $custom_logo_id = get_theme_mod('custom_logo');
    $image = wp_get_attachment_image_src($custom_logo_id, 'full');?>
<img src="<?php echo $image[0]; ?>" alt="">
<?php } else {?>
  <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo.png" alt="Abe Services"><?php } ?>
                                   
                                </a>
                            </div>
                        </div>
                        <div class="col-md-9 header-right pull-right">
                            <div class="social-links">
                                <div class="pull-right">
									              <?php
$query = new WP_Query(array('post_type' => 'social_links', 'posts_per_page' => -1,'post_status' => 'publish', 'order' => 'DESC'));
while ($query->have_posts()): $query->the_post();  
    ?>
                  
                                     <a href="<?php echo get_the_content(get_the_ID()); ?>" class="<?php echo get_post_meta(get_the_ID(), 'class', true); ?>">
                                        <i class="<?php echo get_post_meta(get_the_ID(), 'i-class', true); ?>"></i>
                                    </a>
                                    <?php endwhile; ?> <?php wp_reset_postdata();?>  
                                </div>
                            </div>
                            <div class="header-bottom">
                                <div class="pull-right">
                                    <span class="contact"><?php echo get_post_field('post_content', 79); ?></span>
                                    <a href="#quick-quote" class="quote custom-btn page-scroll">Get a Quote</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </header>
            <nav class="navbar navbar-expand-lg static-top">
                <div class="container">
                    <div class="col-md-12">
                    <div class="row nav-container">
                        <a class="navbar-brand" href="<?php echo home_url(); ?>">
                            
							<?php if (has_custom_logo()) {
    $custom_logo_id = get_theme_mod('custom_logo');
    $image = wp_get_attachment_image_src($custom_logo_id, 'full');?>
<img src="<?php echo $image[0]; ?>" alt="">
<?php } else {?>
  <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo.png" alt="Abe Services"><?php } ?>
                        </a>
                        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarResponsive" aria-controls="navbarResponsive" aria-expanded="false" aria-label="Toggle navigation">
                            <span class="navbar-toggler-icon"></span>
                            <span class="sr-only">Toggle navigation</span>
                        </button>
                        <div class="collapse navbar-collapse" id="navbarResponsive">
                        
                          
                        <?php
wp_nav_menu(array(
    'menu' => 'menu-1',
    'theme_location' => 'Primary',
    'container' => 'navbar-nav',
    'items_wrap' => '<ul class="navbar-nav m-auto">%3$s</ul>',
    'walker' => new Bootstrap_Walker_Nav_Menu(),
));?>
                           
                        </div>
                    </div>
                    </div>
                </div>
                
            </nav>